<x-layout bodyClass="g-sidenav-show  bg-gray-200">
    <x-navbars.sidebar activePage="permission-group"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Permissões"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-md-12">
                    <form method="post" action="{{ route('admin.permissions.update', $role->id) }}" autocomplete="off"
                          class="form-horizontal"
                          enctype="multipart/form-data">
                        @csrf
                        @method('put')

                        <div class="card ">
                            <div class="card-header card-header-primary">
                                <h4 class="card-title">{{ __('Atualizar Permissão') }}</h4>
                                <p class="card-category"></p>
                            </div>
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-md-12 text-right">
                                        <a href="{{ route('admin.permissions.index') }}"
                                           class="btn btn-sm btn-primary">{{ __('Voltar para a lista') }}</a>
                                    </div>
                                </div>

                                @if (isset($success) || isset($error))
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="alert alert-{{(isset($success) ? 'success' : 'danger')}}">
                                                <button type="button" class="close" data-dismiss="alert"
                                                        aria-label="Close">
                                                    <i class="tim-icons icon-simple-remove"></i>
                                                </button>
                                                <span>{{(isset($success) ? $success : $error)}}</span>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                {{-- Role --}}
                                <div class="row">
                                    <label class="col-sm-2 col-form-label">{{ __('Nome') }}</label>
                                    <div class="col-sm-7">
                                        <div class="form-group">
                                            <input class="form-control"
                                                   name="role" id="input-role" type="text"
                                                   placeholder="{{ __('Nome da Permissão') }}"
                                                   value="{{ $role->name ?? old('role') }}"
                                                   required="true" aria-required="true"/>
                                        </div>
                                    </div>
                                </div>
                                <hr />
                                {{-- Permissoes --}}
                                <div class="row">
                                    <label class="col-2 col-form-label">{{ __('Acessos') }}</label>
                                    <div class="col-10 col-md-7 row align-items-center">
                                        @foreach($allPermissions as $key => $permission)
                                            @if($loop->iteration <= 4)
                                                <div class="col-6 col-md-3">
                                                    <div class="form-group row">
                                                        <div class="col-8">
                                                            <label for="permission-{{ $loop->iteration }}">{{ $permission }}</label>
                                                        </div>
                                                        <div class="col-2">
                                                            <input  name="permissions[]" id="permission-{{ $loop->iteration }}" type="checkbox" value="{{ $key ?? old('permission') }}" {{ in_array($key, $permissions->pluck('name')->toArray()) ? 'checked' : '' }} />
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                                <hr />
                                {{-- Permissoes para paginas --}}
                                <div class="row">
                                    <label class="col-2 col-form-label">{{ __('Páginas de acesso') }}</label>
                                    <div class="col-10 col-md-7 row align-items-center">
                                        @foreach($allPermissions as $key => $pagePermission)
                                            @if($loop->iteration > 4)
                                                <div class="col-6 col-md-4">
                                                    <div class="form-group row">
                                                        <div class="col-8">
                                                            <label for="page-permission-{{ $loop->iteration }}">{{ $pagePermission }}</label>
                                                        </div>
                                                        <div class="col-2">
                                                            <input  name="permissions[]" id="page-permission-{{ $loop->iteration }}" type="checkbox" value="{{ $key ?? old('permissionsPage') }}" {{ in_array($key, $permissions->pluck('name')->toArray()) ? 'checked' : '' }} />
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer ml-auto mr-auto">
                                <button type="submit" class="btn btn-primary">{{ __('Atualizar') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>
</x-layout>
