<x-layout bodyClass="g-sidenav-show  bg-gray-200">
    <x-navbars.sidebar activePage="user-management"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="User Management"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-md-12">
                    <form method="post" action="{{ route('admin.users.store') }}" autocomplete="off" class="form-horizontal">
                        @csrf
                        @method('post')

                        <div class="card ">
                            <div class="card-header card-header-primary">
                                <h4 class="card-title">{{ __('Adicionar novo usuário') }}</h4>
                                <p class="card-category"></p>
                            </div>
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-md-12 text-right">
                                        <a href="{{ route('admin.users.index') }}"
                                        class="btn btn-sm btn-primary">{{ __('Voltar para a lista') }}</a>
                                    </div>
                                </div>
                                <div class="row">
                                    {{-- Name --}}
                                    <div class="col-md-8">
                                        <div class="input-group input-group-static my-3 {{ $errors->has('name') ? ' is-invalid' : '' }}">
                                            <label>{{ __('Nome') }}</label>
                                            <input class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}"
                                            name="name" id="input-name" type="text"
                                            value="{{ old('name') }}" placeholder="{{ __('Nome') }}"
                                            required="true" aria-required="true"/>
                                            @if ($errors->has('name'))
                                                <span id="name-error" class="error text-danger"
                                                    for="input-name">{{ $errors->first('name') }}</span>
                                            @endif
                                        </div>
                                    </div>
                                    {{-- Email --}}
                                    <div class="col-md-5">
                                        <div class="input-group input-group-static my-3 {{ $errors->has('email') ? ' is-invalid' : '' }}">
                                            <label>{{ __('E-mail') }}</label>
                                            <input class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}"
                                                name="email" id="input-email" type="email"
                                                value="{{ old('email') }}" placeholder="{{ __('E-mail') }}"
                                                required />
                                            @if ($errors->has('email'))
                                                <span id="email-error" class="error text-danger"
                                                    for="input-email">{{ $errors->first('email') }}</span>
                                            @endif
                                        </div>
                                    </div>
                                    {{-- Tipo --}}
                                    <div class="col-md-3">
                                        <div class="input-group input-group-static my-3 {{ $errors->has('role_id') ? ' is-invalid' : '' }}">
                                            <label>{{ __('Tipo') }}</label>
                                            <select class="form-control" name="role_id" id="input-role_id"
                                            required="true" aria-required="true">
                                                <option value="" disabled selected>Tipo de usuário</option>
                                                @foreach($roles as $role)
                                                    <option class="text-dark" value="{{$role->id}}">{{$role->name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    {{-- Password --}}
                                    <div class="col-md-8">
                                        <div class="input-group input-group-static my-3 {{ $errors->has('password') ? ' is-invalid' : '' }}">
                                            <label for="input-password">{{ __(' Senha') }}</label>
                                            <input class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}"
                                            input type="password" name="password" id="input-password"
                                            placeholder="{{ __('Senha') }}" value="" required/>
                                            @if ($errors->has('password'))
                                                <span id="name-error" class="error text-danger"
                                                    for="input-name">{{ $errors->first('password') }}</span>
                                            @endif
                                        </div>
                                    </div>
                                    {{-- Confirm Password --}}
                                    <div class="col-md-8">
                                        <div class="input-group input-group-static my-3 {{ $errors->has('password_confirmation') ? ' is-invalid' : '' }}">
                                            <label for="input-password-confirmation">{{ __('Confirme sua senha') }}</label>
                                            <input class="form-control" name="password_confirmation"
                                            id="input-password-confirmation" type="password"
                                            placeholder="{{ __('Confirmar senha') }}" value="" required/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer ml-auto mr-auto">
                                <button type="submit" class="btn btn-primary">{{ __('Adicionar usuário') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>
</x-layout>
