<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Contrato;
use App\Services\ContratoService;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class GerarCobrancaAssinatura extends Command
{
    protected $signature = 'assinatura:gerar-cobrancas';
    protected $description = 'Gera cobranças de assinaturas com base na recorrência, vencimento e antecedência
configurados';

    public function __construct(
        protected ContratoService $contratoService
    ) {
        parent::__construct();
    }

    public function handle()
    {
        DB::beginTransaction();
        $contratos = Contrato::where('status', 'CONCLUÍDO')->get();
        $dataAtual = Carbon::now()->format('Y-m-d');

        try {
            foreach ($contratos as $contrato) {
                // Verifica quantos dias de antecedencia foi definido no contrato, a data atual e a data de vencimento.
                if ($contrato->precisaGerarCobranca() && $contrato->dataultimarecorrencia != $dataAtual) {
                    $this->gerarCobranca($contrato);
                    $contrato->dataultimarecorrencia = Carbon::now();
                    $contrato->save();

                }
            }

            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            Log::error("Erro ao gerar as cobrancas: {$e->getMessage()}");
        }
    }

    protected function gerarCobranca($contrato)
    {
        try {
            $this->contratoService->processarRecorrencias($contrato);
        } catch (Exception $e) {
            Log::error("Erro ao gerar as cobrancas: {$e->getMessage()}");
        }
    }
}
