<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;
use App\Models\Pessoa as Model;
use App\Models\TipoPessoa;
use Exception;
use Illuminate\Support\Facades\DB;

class ClienteController extends Controller
{
    public function index()
    {
        $userCurrent = auth()->user();

        if ($userCurrent->representante->tipo == 'R') {
            $clientes = Model::where('pessoapadrao', false)
                                ->where('status', '!=','INATIVO')
                                ->where('idrepresentante', $userCurrent->representante->idpessoa)
                                ->orderBy('nome')
                                ->cliente()
                                ->paginate(100);
        } else {
            $clientes = Model::where('pessoapadrao', false)
                                ->where('status', '!=','INATIVO')
                                ->orderBy('nome')
                                ->cliente()
                                ->paginate(100);
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'POTENCIAL' => 'Potencial',
            'INATIVO' => 'Inativo',
            'SUSPENSO' => 'Suspenso'
            // Adicione mais status conforme necessário
        ];

        return view('admin.clientes.index', compact('clientes', 'statusOptions'));
    }

    public function fetch(Request $request)
    {
        $perPage = $request->input('per_page', 100);

        // Definir os campos e suas classes CSS
        $fields = [
            'ID' => [
                'key' => 'idpessoa',
                'class' => 'text-center text-xs',
            ],
            'EMPRESA' => [
                'key' => 'empresa.sigla',
                'class' => 'text-center text-xs',
            ],
            'NOME' => [
                'key' => 'nome',
                'class' => 'text-start text-xs',
            ],
            'RAZÃO SOCIAL' => [
                'key' => fn($cliente) => $cliente->razaosocial ?? '-',
                'class' => 'text-start text-xs',
            ],
            'CPF / CNPJ' => [
                'key' => fn($cliente) => $cliente->cpfcnpj ?? '-',
                'class' => 'text-center text-xs',
            ],
            'STATUS' => [
                'key' => fn($tagTipo) => view('partials.status-progress', [
                    'status' => $tagTipo->status,
                    'id' => $tagTipo->idtagtipo,
                    'options' => [
                        ['percentage' => 50, 'status' => 'INATIVO', 'tooltip' => 'Inativo', 'class' => 'bg-danger'],
                        ['percentage' => 50, 'status' => 'SUSPENSO', 'tooltip' => 'Suspenso', 'class' => 'bg-warning'],
                        ['percentage' => 50, 'status' => 'POTENCIAL', 'tooltip' => 'Suspenso', 'class' => 'bg-info'],
                        ['percentage' => 50, 'status' => 'ATIVO', 'tooltip' => 'Ativo', 'class' => 'bg-success'],
                    ]
                ])->render(),
                'class' => 'no-clicked pe-3',
            ]
        ];

        // Buscar os dados paginados
        $userCurrent = auth()->user();

        if ($userCurrent->representante->tipo == 'R') {
            $clientes = Model::where('pessoapadrao', false)
                                ->where('status', '!=','INATIVO')
                                ->where('idrepresentante', $userCurrent->representante->idpessoa)
                                ->orderBy('nome')
                                ->cliente()
                                ->paginate($perPage, ['*'], 'page', $request->input('page', 2));
        } else {
            $clientes = Model::where('pessoapadrao', false)
                                ->where('status', '!=','INATIVO')
                                ->orderBy('nome')
                                ->cliente()
                                ->paginate($perPage, ['*'], 'page', $request->input('page', 2));;
        }

        // Montar os dados processados para o frontend
        $processedData = $clientes->map(function ($cliente) use ($fields) {
            $row = [
                'url' => route('admin.clientes.edit', $cliente->idpessoa),
            ];
            foreach ($fields as $label => $field) {
                $value = is_callable($field['key'])
                    ? $field['key']($cliente) // Executar a closure
                    : data_get($cliente, $field['key']); // Obter o valor diretamente
                $row[$label] = [
                    'value' => $value,
                    'class' => $field['class'],
                ];
            }
            return $row;
        });

        // Retornar os dados processados como JSON
        return response()->json([
            'columns' => array_keys($fields),
            'data' => $processedData,
            'next_page_url' => $clientes->nextPageUrl(),
        ]);
    }

    public function create(Empresa $empresaModel, TipoPessoa $tipoPessoaModel)
    {
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        $tipoPessoa = $tipoPessoaModel
            ->orderBy('tipopessoa')
            ->active()
            ->get();

        $statusOptions = [
                'ATIVO' => 'Ativo',
                'POTENCIAL' => 'Potencial',
                'INATIVO' => 'Inativo',
                'SUSPENSO' => 'Suspenso'
                // Adicione mais status conforme necessário
            ];


        return view('admin.clientes.create')->with(compact('empresas', 'tipoPessoa','statusOptions'));
    }

    public function store(Request $request)
    {
        $pessoaCreate = $request->all();

        try {
            Model::create($pessoaCreate);

            // @TODO: Gerar usuario com permissões padroes

            return redirect()
                ->route('admin.clientes.index')
                ->with('success', 'Pessoa criada com sucesso!');
        } catch (Exception $e) {
            return redirect()
                ->back()
                ->withInput()
                ->with('error', $e->getMessage());
        }
    }

    public function edit($idPessoa, Empresa $empresaModel, TipoPessoa $tipoPessoaModel)
    {
        $pessoa = Model::find($idPessoa);
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        $tipoPessoa = $tipoPessoaModel
            ->orderBy('tipopessoa')
            ->active()
            ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'POTENCIAL' => 'Potencial',
            'INATIVO' => 'Inativo',
            'SUSPENSO' => 'Suspenso'
            // Adicione mais status conforme necessário
        ];


        if ($pessoa->status == 'ATIVO') {
            $bg_status = "bg-success";
        } elseif ($pessoa->status == 'POTENCIAL') {
            $bg_status = "bg-info";
        } elseif ($pessoa->status == 'SUSPENSO') {
            $bg_status = "bg-warning";
        } elseif ($pessoa->status == 'INATIVO') {
            $bg_status = "bg-danger";
        }

        return view('admin.clientes.edit')->with(compact('pessoa', 'empresas', 'tipoPessoa', 'statusOptions', 'bg_status'));
    }

    public function update($idPessoa, Request $request)
    {
        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $pessoa = Model::find($idPessoa);

        DB::beginTransaction();
        try {
            $pessoa->update($request->all());

            if ($redirect == false) {
                DB::commit();
                return response()->json($pessoa->status);
            }

            DB::commit();
            return redirect()
                ->route('admin.clientes.edit', $pessoa)
                ->with('success', 'Pessoa atualizada!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()
                ->route('admin.clientes.index')
                ->with('error', $e->getMessage())
                ->withInput();
        }
    }

    public function destroy()
    {
    }

    public function search(Request $request)
    {
        $clientes =  Model::where('nome', 'like', '%'.$request->search.'%')
                    ->where('status', 'like', '%'.$request->status.'%')
                    ->orderBy('nome')
                    ->paginate(15);

        $size = $clientes->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 ) {
            session()->flash('success', $size.' valor(es) encontrado(s).');
        } else {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'POTENCIAL' => 'Potencial',
            'SUSPENSO' => 'Suspenso',
            'INATIVO' => 'Inativo',
        ];

        return view('admin.clientes.index')->with(compact('clientes', 'statusOptions'));
    }
}
