<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\{ContratoVeiculo, Empresa, Nf, Veiculo};
use Illuminate\Http\Request;

class DashboardVeiculoCustoController extends Controller
{
    public function index(Empresa $empresaModel, ContratoVeiculo $contratoVeiculoModel, Veiculo $veiculoModel)
    {
        $graficoPedidosDieselPorMes = [];
        $mediasPedidoMesAtual = [];
        $totalPedidosVeiculoMesAtual = 0;
        $percentualPedidosVeiculoMudanca = 0;
        $totalPedidosDieselMesAtual = 0;
        $percentualPedidosDieselMudanca = 0;
        $totalPedidosQtdDieselMesAtual = 0;
        $percentualPedidosQtdDieselMudanca = 0;
        $totalPedidosQtdDieselMesPassado = 0;
        $mediaConsumoMesAtual = 0;
        $listaPedido = [];

        $empresas = $empresaModel->orderBy('razaosocial')->get();
        $veiculos = $veiculoModel->orderBy('placa')->get();
        $contratos = $contratoVeiculoModel->select(['contratoveiculo.*', 'empresa.sigla'])
            ->with(['contrato', 'empresa'])
            ->leftJoin('empresa', 'empresa.idempresa', '=', 'contratoveiculo.idempresa')
            ->orderBy('criadoem', 'desc')
            ->get();

        return view('dashboard.veiculocusto',
            compact(
                'graficoPedidosDieselPorMes',
                'mediasPedidoMesAtual',
                'totalPedidosVeiculoMesAtual',
                'percentualPedidosVeiculoMudanca',
                'totalPedidosDieselMesAtual',
                'percentualPedidosDieselMudanca',
                'totalPedidosQtdDieselMesAtual',
                'percentualPedidosQtdDieselMudanca',
                'totalPedidosQtdDieselMesPassado',
                'mediaConsumoMesAtual',
                'listaPedido',
                'empresas',
                'contratos',
                'veiculos'
            )
        );
    }

    public function search(Request $request, Empresa $empresaModel, ContratoVeiculo $contratoVeiculoModel, Veiculo $veiculoModel)
    {
        $query = Nf::pedido()
            ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
            ->whereNotIn('idprodserv', [20, 31])
            ->where('idprodservtipo','=',2);

        filter($request, $query, 'nf');

        $resultado = $query->get();

        $graficoPedidosDieselPorMes = calcularMediaConsumoPorMes($request) ?? [];
        $mediasPedidoMesAtual = $this->calcularMediaPedidoMesAtual($request) ?? [];
        $totalPedidosVeiculoMesAtual = $resultado->sum('valoritem');
        $percentualPedidosVeiculoMudanca = 0;
        $totalPedidosDieselMesAtual = $this->calcularTotalPedidosDieselMesAtual($request) ?? 0;
        $percentualPedidosDieselMudanca = 0;
        $totalPedidosQtdDieselMesAtual = $this->calcularTotalPedidosQtdDieselMesAtual($request) ?? 0;
        $percentualPedidosQtdDieselMudanca = 0;
        $totalPedidosQtdDieselMesPassado = 0;
        $mediaConsumoMesAtual = calcularMediaConsumo($request);
        $listaPedido = $this->getListaPedidos($request);

        $empresas = $empresaModel->orderBy('razaosocial')->get();
        $veiculos = $veiculoModel->orderBy('placa')->get();
        $contratos = $contratoVeiculoModel->select(['contratoveiculo.*', 'empresa.sigla'])
            ->with(['contrato', 'empresa'])
            ->leftJoin('empresa', 'empresa.idempresa', '=', 'contratoveiculo.idempresa')
            ->orderBy('criadoem', 'desc')
            ->get();

        return view('dashboard.veiculocusto',
            compact(
                'graficoPedidosDieselPorMes',
                'mediasPedidoMesAtual',
                'totalPedidosVeiculoMesAtual',
                'percentualPedidosVeiculoMudanca',
                'totalPedidosDieselMesAtual',
                'percentualPedidosDieselMudanca',
                'totalPedidosQtdDieselMesAtual',
                'percentualPedidosQtdDieselMudanca',
                'totalPedidosQtdDieselMesPassado',
                'mediaConsumoMesAtual',
                'listaPedido',
                'empresas',
                'contratos',
                'veiculos'
            )
        );
    }

    private function getListaPedidos($request)
    {
        $query = Nf::select([
            'nf.idnf',
            'nf.idveiculo',
            'nf.dataentrada',
            'nf.km',
            'veiculo.placa',
            'veiculo.dashboard',
            'pessoa.nome',
            'nfitem.qtd',
            'nfitem.valoritem',
            'nfitem.valorun',
            'nfitem.un',
            'prodserv.idprodserv',
            'prodserv.prodserv'
        ])
        ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
        ->join('veiculo', 'veiculo.idveiculo', '=', 'nf.idveiculo')
        ->join('prodserv', 'prodserv.idprodserv', '=', 'nfitem.idprodserv')
        ->leftJoin('pessoa', 'pessoa.idpessoa', '=', 'veiculo.idpessoa')
        ->whereNotIn('nfitem.idprodserv', [20, 31])
        ->where('nf.saida', 'P')
        ->where('nf.idprodservtipo', 2)
        ->where('nfitem.qtd', '>', 0);

        filter($request, $query, 'nf');

        $resultados = $query->orderBy('veiculo.dashboard', 'desc')
            ->orderBy('veiculo.marca')
            ->orderBy('veiculo.placa')
            ->orderBy('nf.dataentrada')
            ->get();

        $dates = getDatesFromFilter($request);
        $inicio = $dates['dataInicio'];

        $anterior = 0;
        // Processa cada resultado para inserir o último quilômetro antes do início
        foreach ($resultados as $resultado) {
            if (!isset($ultimoKm[$resultado->idveiculo])) {
                // Se for o primeiro registro do veículo no período, busca o último KM antes do início
                $ultimoKm[$resultado->idveiculo] = getUltimoKmAntesDe($resultado->idveiculo, $inicio);
                $resultado->ultimokm = $ultimoKm[$resultado->idveiculo];
            } else {
                // Se já houver um registro, usa o KM anterior do mesmo período
                $resultado->ultimokm = $anterior;
            }
            // Atualiza o último KM conhecido para esse veículo
            $ultimoKm[$resultado->idveiculo] = $resultado->km;
            $anterior = $resultado->km;
        }

        return $resultados; // Retorna os resultados da consulta
    }

    private function calcularMediaPedidoMesAtual($request)
    {
        $query = Nf::select([
            'nf.idnf',
            'nfitem.valoritem',
            'nf.idveiculo',
            'veiculo.placa as rotulo'
        ])
        ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
        ->join('veiculo', 'veiculo.idveiculo', '=', 'nf.idveiculo')
        ->whereIn('nfitem.idprodserv', [20, 31])
        ->where('nf.saida', 'P')
        ->where('nfitem.qtd', '>', 0);

        filter($request, $query, 'nf');

        $resultados = $query->orderBy('nf.idveiculo')
            ->orderBy('nf.dataentrada')
            ->get();

        // Estruturas para armazenar os custos por veículo
        $custosPorVeiculo = [];
        foreach ($resultados as $registro) {
            $idVeiculo = $registro->idveiculo;
            $valorItem = $registro->valoritem;
            $rotulo = $registro->rotulo; // Placa do veículo

            if (!isset($custosPorVeiculo[$idVeiculo])) {
                $custosPorVeiculo[$idVeiculo] = [
                    'rotulo' => $rotulo,
                    'custoTotal' => 0
                ];
            }

            // Acumula o valor do item no custo total do veículo
            $custosPorVeiculo[$idVeiculo]['custoTotal'] += $valorItem;
        }

        // Preparando dados para ordenação e exibição
        $custosTotaisPorVeiculo = [];
        foreach ($custosPorVeiculo as $idVeiculo => $info) {
            $custosTotaisPorVeiculo[] = [
                'id' => $idVeiculo,
                'rotulo' => $info['rotulo'],
                'valor' => $info['custoTotal']
            ];
        }

        // Ordena o array pelo custo total em ordem decrescente
        usort($custosTotaisPorVeiculo, function ($item1, $item2) {
            return $item2['valor'] <=> $item1['valor'];
        });

        // Retorna o vetor ordenado de custos totais por veículo
        return $custosTotaisPorVeiculo;
    }

    private function calcularTotalPedidosDieselMesAtual($request)
    {
        $query = Nf::pedido()
            ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
            ->whereIn('idprodserv', [20, 31]);

        filter($request, $query, 'nf');

        $resultados = $query->get();

        return $resultados->sum('valoritem');
    }

    private function calcularTotalPedidosQtdDieselMesAtual($request)
    {
        $query = Nf::pedido()
            ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
            ->whereIn('idprodserv', [20, 31]);

        filter($request, $query, 'nf');

        $resultados = $query->get();

        return $resultados->sum('qtd');
    }
}
