<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\HandlesFileUploads;
use App\Models\Upload;
use Illuminate\Http\Request;

class FileUploadTraitController extends Controller
{
    use HandlesFileUploads;
    
    public function destroy(Upload $upload)
    {
        try {
            $upload->delete(); // O evento deleting no modelo Upload deve lidar com a exclusão do arquivo
            return response()->json(['success' => true, 'message' => 'Arquivo excluído com sucesso.']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Erro ao excluir arquivo.']);
        }
    }

}
