<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\NfItem as Model;
use Exception;

class NfItemController extends Controller
{
    public function index()
    {
        $nfitens = Model::latest()
                    ->paginate(100);

        return view('admin.nfitens.index')->with(compact('nfitens'));
    }

    public function destroy($idNfItem)
    {
        $nfitems = Model::findOrFail($idNfItem);

        try
        {
            $nfitems->delete();

            return redirect()
                    ->route('admin.compras.index')
                    ->with('success', 'Item removido!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    
    public function delete($id)
    {
        Model::find($id)->delete();
  
        return response()->json(['success'=>'User Deleted Successfully!']);
    }

    public function getbynf($idNf)
    {
        try {
            $nfItems = Model::where('idnf', $idNf)->with('prodserv')->get();
            return response()->json([
                'success' => true,
                'items' => $nfItems,
            ]);
        } catch (Exception $e) {
            return response()->json(['success' => false, 'error' => $e->getMessage()]);
        }
    }



}
