<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Nf;
use App\Models\NfParcela;
use App\Scopes\TenantScope;

class PagamentoController extends Controller
{
    public function index()
    {
        $pessoa = auth()->user()->tenant->idpessoa;
        $pagamentos = Nf::withoutGlobalScope(TenantScope::class)
            ->with('parcelaWithoutGlobalScope', 'nfitemWithoutGlobalScope')
            ->where('idpessoa', $pessoa)
            ->orderBy('idnf', 'desc')
            ->get();

        return view('admin.pagamentos.index', compact('pagamentos'));
    }
}
