<?php

namespace App\Http\Livewire;

use App\Models\Agencia;
use Livewire\Component;

class GraphAgenciaComponent extends Component
{
    public $GraficoSaldoTotalAgencias;

    public function mount()
    {
        $agencias = Agencia::all();

        $agenciasToArray = $agencias->map(function ($agencia) {
            if ($agencia && $agencia->nome && $agencia->nagencia) {
                return "{$agencia->nome}/{$agencia->nagencia}";
            }

            return null;
        })->toArray();

        $saldoatualToArray = $agencias->map(function ($agencia) {
            if ($agencia && $agencia->saldoatual) {
                return $agencia->saldoatual;
            }

            return 0;
        })->toArray();

        $this->GraficoSaldoTotalAgencias = [
            'labels' => $agenciasToArray,
            'data' => $saldoatualToArray
        ];
    }

    public function render()
    {
        return view('livewire.graph-agencia-component', [
            'GraficoSaldoTotalAgencias' => $this->GraficoSaldoTotalAgencias
        ]);
    }
}
