<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;

class GraphCompraComponent extends Component
{
    public $comprasMesAtual;
    public $comprasMesPassado;
    public $totalComprasMesAtual;
    public $totalComprasMesPassado;
    public $percentualComprasMudanca;


    public function mount()
    {
        $inicioMesAtual = Carbon::now()->startOfMonth();
        $finalMesAtual = Carbon::now()->endOfMonth();
        
        $inicioMesPassado = Carbon::now()->subMonthNoOverflow()->startOfMonth();
        $finalMesPassado = Carbon::now()->subMonthNoOverflow()->endOfMonth();

        $this->comprasMesAtual = Nf::compra()
                                   ->whereBetween('dataentrada', [$inicioMesAtual, $finalMesAtual])
                                   ->get();

        $this->comprasMesPassado = Nf::compra()
                                     ->whereBetween('dataentrada', [$inicioMesPassado, $finalMesPassado])
                                     ->get();

        $this->totalComprasMesAtual = $this->comprasMesAtual->sum('valornf');
        $this->totalComprasMesPassado = $this->comprasMesPassado->sum('valornf');
        $this->percentualComprasMudanca = $this->totalComprasMesPassado > 0 
                                    ? (($this->totalComprasMesAtual - $this->totalComprasMesPassado) / $this->totalComprasMesPassado) * 100 
                                    : 0;
    }

    public function render()
    {
        return view('livewire.graph-compra-component', [
            'comprasMesAtual' => $this->comprasMesAtual,
            'comprasMesPassado' => $this->comprasMesPassado,
            'percentualComprasMudanca' => $this->percentualComprasMudanca,
            'totalComprasMesAtual' => $this->totalComprasMesAtual,
            'totalComprasMesPassado' => $this->totalComprasMesPassado           

        ]);
    }
}


