<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\NfParcela;
use Carbon\Carbon;

class GraphNfParcelaDebitoJsComponent extends Component
{
    public $DadosNfParcelaDebitoMes;
    public $GraficoNfParcelaDebitoMes;

    public function mount()
    {
        $dadosMeses = collect();

        // Preenche os últimos 6 meses
        for ($i = 5; $i >= 0; $i--) {
            $mes = Carbon::now()->subMonths($i);
            $dadosMeses->push([
                'mes' => $mes->month,
                'ano' => $mes->year,
                'total' => 0
            ]);
        }

        // Consulta os dados
        $dadosConsulta = NfParcela::debito()->concluido()
            ->selectRaw('MONTH(datavencimento) as mes, YEAR(datavencimento) as ano,  COALESCE(SUM(valor), 0) as total')
            ->where('datavencimento', '>=', Carbon::now()->subMonths(6))
            ->groupBy('mes', 'ano')
            ->get();

        // Preenche os dados nos meses
        $dadosMeses->transform(function ($mes) use ($dadosConsulta) {
            foreach ($dadosConsulta as $dado) {
                if ($mes['mes'] == $dado->mes && $mes['ano'] == $dado->ano) {
                    $mes['total'] = $dado->total;
                    break;
                }
            }
            return $mes;
        });

        $this->DadosNfParcelaDebitoMes = $dadosMeses;

        $this->GraficoNfParcelaDebitoMes = [
            'labels' => $dadosMeses->map(fn($mes) => "{$mes['mes']}/{$mes['ano']}")->toArray(),
            'data' => $dadosMeses->map(fn($mes) => $mes['total'])->toArray()
        ];
    }

    public function render()
    {
        return view('livewire.graph-nf-parcela-debito-js-component', [
            'DadosNfParcelaDebitoMes' => $this->DadosNfParcelaDebitoMes,
            'GraficoNfParcelaDebitoMes' => $this->GraficoNfParcelaDebitoMes
        ]);
    }
}
