<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\NfParcela;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use App\Services\DateRangeService;

class ListaNfParcelaMovimentacaoComponent extends Component
{
    public $listaParcelas;
    public $datarange; // Adicione se necessário
    public $idempresa; // Adicione se necessário
    public $idveiculo; // Adicione se necessário
    public $idcontrato; // Adicione se necessário
    public $idagencia; // Adicione se necessário

    protected $listeners = ['filtersApplied' => 'onFilterUpdate']; // Escutando eventos de filtro



    public function mount()
    {
        $this->loadInitialData();
    }

    public function loadInitialData()
    {
        if (empty($this->datarange)) {
            $this->setInitialDateRange();
        }
        $this->loadData();
    }

    private function setInitialDateRange()
    {
        $dataInicio = Carbon::now()->startOfMonth()->format('d-m-Y');
        $dataFim = Carbon::now()->endOfMonth()->format('d-m-Y');
        $this->datarange = $dataInicio . ' até ' . $dataFim;
    }

    private function loadData()
    {
        $dates = DateRangeService::generateDateRange($this->datarange);

        $this->listaParcelas = $this->listarParcelas($dates['dataInicio'], $dates['dataFim']);

        // Calcula o saldo atual somando créditos e subtraindo débitos
        $this->saldoAtual = $this->calcularSaldoAtual($this->listaParcelas);


      $this->dispatchBrowserEvent('listaParcelasAtualizada', [
        'listaParcelas' => $this->listaParcelas
    ]);


    }

    public function render()
    {
        return view('livewire.lista-nf-parcela-movimentacao-component', [
            'listaParcelas' => $this->listaParcelas
        ]);
    }

    private function listarParcelas($inicio, $fim)
    {
        $parcelas = NfParcela::with(['nf.pessoa','nf.fornecedor','nf.cliente'])
        ->whereBetween('datatransacao', [$inicio, $fim])
            ->where('status', 'concluido')
            ->orderBy('datatransacao', 'asc');

        // Filtros opcionais
        if ($this->idempresa) {
            $parcelas->where('idempresa', $this->idempresa);
        }

        if ($this->idveiculo) {
            $parcelas->where('idveiculo', $this->idveiculo);
        }

        if ($this->idcontrato) {
            $parcelas->whereExists(function ($subquery) {
                $subquery->select(DB::raw(1))
                    ->from('contratoveiculo as cv')
                    ->whereColumn('cv.idveiculo', 'nf_parcela.idveiculo')
                    ->where('cv.idcontrato', $this->idcontrato);
            });
        }

        if ($this->idagencia) {
            $parcelas->whereExists(function ($subquery) {
                $subquery->select(DB::raw(1))
                    ->from('agencia as a')
                    ->whereColumn('a.idagencia', 'nfparcela.idagencia')
                    ->where('a.idagencia', $this->idagencia);
            });
        }

        return $parcelas->get();
    }

    private function calcularSaldoAtual($parcelas)
    {
        $saldo = 0;
        foreach ($parcelas as $parcela) {
            if ($parcela->tipo == 'credito') {
                $saldo += $parcela->valor;
            } elseif ($parcela->tipo == 'debito') {
                $saldo -= $parcela->valor;
            }
        }
        return $saldo;
    }


    public function onFilterUpdate($filters)
    {
        $this->datarange = $filters['datarange'] ?? null;
        $this->idempresa = $filters['idempresa'] ?? null;
        $this->idveiculo = $filters['idveiculo'] ?? null;
        $this->idcontrato = $filters['idcontrato'] ?? null;
        $this->idagencia = $filters['idagencia'] ?? null;
        $this->loadData();
//dd($this->datarange);
        $this->dispatchBrowserEvent('listaParcelasAtualizada', [
            'listaParcelas' => $this->listaParcelas
        ]);
    }


}


