<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use App\Services\DateRangeService;

class ListaPedidoVeiculoComponent extends Component
{
    public $listaPedido;
    public $datarange; // Adicione se necessário
    public $idempresa; // Adicione se necessário
    public $idveiculo; // Adicione se necessário
    public $idcontrato; // Adicione se necessário

    protected $listeners = ['filtersApplied' => 'onFilterUpdate']; // Escutando eventos de filtro



    public function mount()
    {
        $this->loadInitialData();
    }

    public function loadInitialData()
    {
        if (empty($this->datarange)) {
            $this->setInitialDateRange();
        }
        $this->loadData();
    }

    private function setInitialDateRange()
    {
        $dataInicio = Carbon::now()->startOfMonth()->format('d-m-Y');
        $dataFim = Carbon::now()->endOfMonth()->format('d-m-Y');
        $this->datarange = $dataInicio . ' até ' . $dataFim;
    }

    private function loadData()
    {
        $dates = DateRangeService::generateDateRange($this->datarange);
        $inicioMesAtual = '2024-01-01';
        $finalMesAtual = '2024-01-30';

         // Agora você pode chamar a função e obter as médias ordenadas
        $this->listaPedido = $this->listarPedidos($dates['dataInicio'], $dates['dataFim']);


        // Exemplo de como exibir as médias de consumo por veículo
    //    foreach ($mediasConsumoMesAtual as $idVeiculo => $mediaConsumo) {
      //      echo "Veículo $idVeiculo: " . number_format($mediaConsumo, 2, '.', '') . " km/l<br>";
      //  }

      $this->dispatchBrowserEvent('listaPedidoAtualizada', [
        'listaPedido' => $this->listaPedido
    ]);


    }

    public function render()
    {
        return view('livewire.lista-pedido-veiculo-component', [
            'listaPedido' => $this->listaPedido
        ]);
    }

    function listarPedidos($inicio, $fim) {
        // Constrói a consulta SQL básica
        $sql = "
            SELECT
                n.idnf,
                n.dataentrada,
                v.placa,
                p.nome,
                n.km,
                ni.qtd,
                n.idveiculo,
                v.dashboard,
                ps.prodserv,
                ni.valoritem,
                ni.valorun,
                ni.un,
                ni.qtd,
                ps.idprodserv
            FROM nf n
            JOIN nfitem ni ON n.idnf = ni.idnf
            JOIN veiculo v on v.idveiculo = n.idveiculo
            JOIN prodserv ps on ps.idprodserv = ni.idprodserv
            LEFT JOIN pessoa p on p.idpessoa = v.idpessoa
            WHERE not ni.idprodserv IN (20, 31)
            AND n.dataentrada BETWEEN ? AND ?
            AND n.saida = 'P'
            AND n.idprodservtipo = 2
            AND ni.qtd > 0";

        $bindings = [$inicio, $fim]; // Prepara os parâmetros para a consulta

        // Adiciona filtros de idempresa ou idveiculo se eles forem fornecidos
        if (!empty($this->idempresa)) {
            $sql .= " AND n.idempresa = ?";
            $bindings[] = $this->idempresa; // Adiciona o id da empresa aos bindings
        }

        // Se o idcontrato foi fornecido, filtra apenas os veículos que
        // possuem um contrato com o idcontrato informado
        if (!empty($this->idcontrato)) {
            $sql .= " AND EXISTS (
                SELECT 1
                FROM contratoveiculo cv
                WHERE cv.idveiculo = n.idveiculo
                AND cv.idcontrato = ?
            )";
            $bindings[] = $this->idcontrato;
        }

        if (!empty($this->idveiculo)) {
            $sql .= " AND n.idveiculo = ?";
            $bindings[] = $this->idveiculo; // Adiciona o id do veículo aos bindings
        }

        $sql .= " ORDER BY v.dashboard desc, v.marca, v.modelo, v.placa, n.dataentrada"; // Finaliza a consulta com a ordenação

        // Executa a consulta
        $resultados = DB::select(DB::raw($sql), $bindings);
        $anterior = 0;
        // Processa cada resultado para inserir o último quilômetro antes do início
        foreach ($resultados as $resultado) {
            if (!isset($ultimoKm[$resultado->idveiculo])) {
                // Se for o primeiro registro do veículo no período, busca o último KM antes do início
                $ultimoKm[$resultado->idveiculo] = $this->getUltimoKmAntesDe($resultado->idveiculo, $inicio);
                $resultado->ultimokm = $ultimoKm[$resultado->idveiculo];
            } else {
                // Se já houver um registro, usa o KM anterior do mesmo período
                $resultado->ultimokm = $anterior;
            }
            // Atualiza o último KM conhecido para esse veículo
            $ultimoKm[$resultado->idveiculo] = $resultado->km;
            $anterior = $resultado->km;
        }
    //dump($resultados);
        return $resultados; // Retorna os resultados da consulta
    }

    function getUltimoKmAntesDe($idVeiculo, $dataInicio) {
        $ultimoRegistro = DB::table('nf')
            ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
            ->where('nf.idveiculo', $idVeiculo)
            ->where('nf.dataentrada', '<', $dataInicio)
            ->whereIn('nfitem.idprodserv', [20, 31])  // Correção aqui, usando whereIn corretamente
            ->orderByDesc('nf.dataentrada')
            ->first();

        return $ultimoRegistro ? $ultimoRegistro->km : 0;
    }

    public function onFilterUpdate($filters)
    {
        $this->datarange = $filters['datarange'] ?? null;
        $this->idempresa = $filters['idempresa'] ?? null;
        $this->idveiculo = $filters['idveiculo'] ?? null;
        $this->idcontrato = $filters['idcontrato'] ?? null;
        $this->loadData();
//dd($this->datarange);
        $this->dispatchBrowserEvent('listaPedidoAtualizada', [
            'listaPedido' => $this->listaPedido
        ]);
    }


}


