<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\NfParcela;
use Carbon\Carbon;

class LucroLiquidoComponent extends Component
{
    public $lucroLiquidoMesAtual;
    public $lucroLiquidoMesPassado;
    public $percentualLucroMudanca;

    public function mount()
    {
        $inicioMesAtual = Carbon::now()->startOfMonth();
        $finalMesAtual = Carbon::now()->endOfMonth();
        $inicioMesPassado = Carbon::now()->subMonthNoOverflow()->startOfMonth();
        $finalMesPassado = Carbon::now()->subMonthNoOverflow()->endOfMonth();

        $totalCreditoMesAtual = NfParcela::credito()->concluido()
                                ->whereBetween('datavencimento', [$inicioMesAtual, $finalMesAtual])
                                ->sum('valor');

        $totalDebitoMesAtual = NfParcela::debito()->concluido()
                                ->whereBetween('datavencimento', [$inicioMesAtual, $finalMesAtual])
                                ->sum('valor');

        $totalCreditoMesPassado = NfParcela::credito()->concluido()
                                ->whereBetween('datavencimento', [$inicioMesPassado, $finalMesPassado])
                                ->sum('valor');

        $totalDebitoMesPassado = NfParcela::debito()->concluido()
                                ->whereBetween('datavencimento', [$inicioMesPassado, $finalMesPassado])
                                ->sum('valor');

        $this->lucroLiquidoMesAtual = $totalCreditoMesAtual - $totalDebitoMesAtual;
        $this->lucroLiquidoMesPassado = $totalCreditoMesPassado - $totalDebitoMesPassado;

        $this->percentualLucroMudanca = $this->lucroLiquidoMesPassado > 0 
                                        ? (($this->lucroLiquidoMesAtual - $this->lucroLiquidoMesPassado) / $this->lucroLiquidoMesPassado) * 100 
                                        : 0;
    }

    public function render()
    {
        return view('livewire.lucro-liquido-component', [
            'lucroLiquidoMesAtual' => $this->lucroLiquidoMesAtual,
            'lucroLiquidoMesPassado' => $this->lucroLiquidoMesPassado,
            'percentualLucroMudanca' => $this->percentualLucroMudanca,
        ]);
    }
}
