<?php
namespace App\Http\Livewire;

use Livewire\Component;
use DB;

class NfItemDebitoComponent extends Component
{
    public $GraficoNfItemDebito;

    public function mount()
    {
        // Substitua esta linha pela sua consulta SQL específica
        $dadosBrutos = DB::select("
            SELECT COALESCE(gi.grupoitem, 'Vazio') AS grupoitem, SUM(valoritem) as total, n.datavencimento
            FROM nf n
            JOIN nfitem ni ON n.idnf = ni.idnf
            JOIN item i ON i.iditem = ni.iditem
            LEFT JOIN grupoitem gi ON gi.idgrupoitem = i.idgrupoitem
            WHERE tipo = 'D' AND n.idempresa = 7
            GROUP BY COALESCE(gi.grupoitem, 'Vazio'), n.datavencimento;
        ");

        $grupos = collect($dadosBrutos)->groupBy('grupoitem')->keys();

        $this->GraficoNfItemDebito = [
            'labels' => $grupos->all(),
            'datasets' => collect($dadosBrutos)->groupBy('datavencimento')->map(function ($data, $key) {
                return [
                    'label' => (new \DateTime($key))->format('m/Y'),
                    'data' => $data->mapWithKeys(function ($item) {
                        return [$item->grupoitem => $item->total];
                    })->all()
                ];
            })->values()->all()
        ];
    }

    public function render()
    {
        return view('livewire.nf-item-debito-component', [
            'GraficoNfItemDebito' => $this->GraficoNfItemDebito
        ]);
    }
}
