<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;

class PedidoComponent extends Component
{
    public $pedidosMesAtual;
    public $pedidosMesPassado;
    public $totalPedidosMesAtual;
    public $totalPedidosMesPassado;
    public $percentualPedidosMudanca;


    public function mount()
    {
        $inicioMesAtual = Carbon::now()->startOfMonth();
        $finalMesAtual = Carbon::now()->endOfMonth();
        
        $inicioMesPassado = Carbon::now()->subMonthNoOverflow()->startOfMonth();
        $finalMesPassado = Carbon::now()->subMonthNoOverflow()->endOfMonth();

        $this->pedidosMesAtual = Nf::pedido()
                                   ->whereBetween('dataentrada', [$inicioMesAtual, $finalMesAtual])
                                   ->get();

        $this->pedidosMesPassado = Nf::pedido()
                                     ->whereBetween('dataentrada', [$inicioMesPassado, $finalMesPassado])
                                     ->get();

                                /*  $query = Nf::pedido()
                                     ->whereBetween('dataentrada', [$inicioMesAtual, $finalMesAtual])
                                     ->toSql();
                                 
                                 $bindings = Nf::pedido()
                                     ->whereBetween('dataentrada', [$inicioMesAtual, $finalMesAtual])
                                     ->getBindings();
                                 
                                 // Substitui cada '?' por uma string que contém a representação do binding no SQL
                                 $fullSql = preg_replace_callback('/\?/', function ($match) use (&$bindings) {
                                     $item = array_shift($bindings);
                                     return is_numeric($item) ? $item : "'".$item."'";
                                 }, $query);
                                 
                                 dd($fullSql);*/
                                 

        $this->totalPedidosMesAtual = $this->pedidosMesAtual->sum('valornf');
        $this->totalPedidosMesPassado = $this->pedidosMesPassado->sum('valornf');
        $this->percentualPedidosMudanca = $this->totalPedidosMesPassado > 0 
                                    ? (($this->totalPedidosMesAtual - $this->totalPedidosMesPassado) / $this->totalPedidosMesPassado) * 100 
                                    : 0;
    }

    public function render()
    {
        return view('livewire.pedido-component', [
            'pedidosMesAtual' => $this->pedidosMesAtual,
            'pedidosMesPassado' => $this->pedidosMesPassado,
            'percentualPedidosMudanca' => $this->percentualPedidosMudanca,
            'totalPedidosMesAtual' => 1,
            'totalPedidosMesPassado' => $this->totalPedidosMesPassado

        ]);
    }
}


