<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\ProdutoServico;
use Carbon\Carbon;
use App\Services\EstoqueService;

class ProdutoEstoqueCimentoComponent extends Component
{

    public $estoqueAtualProduto;
    private $estoqueService;
    private $idProdutoServico = 16; // Definindo o id do produto como 20
    private $estoqueMinimo;
    private $quantidadeParaEstoqueMinimo;

    public function __construct()
    {
        $this->estoqueService = app(EstoqueService::class); // Injetando a dependência
    }


    public function mount()
    {

        $this->estoqueAtualProduto = $this->estoqueService->calcularEstoqueAtual($this->idProdutoServico);

        $produto = ProdutoServico::find($this->idProdutoServico);
        if ($produto) {
            $this->estoqueMinimo = $produto->estoqueminimo;
            // Calcular quanto falta para atingir o estoque mínimo
            $this->quantidadeParaEstoqueMinimo =  $this->estoqueAtualProduto - $this->estoqueMinimo ;
        }
        
    }

    public function render()
    {
        return view('livewire.produto-estoque-cimento-component', [
            'estoqueAtualProduto' => $this->estoqueAtualProduto,
            'estoqueMinimo' => $this->estoqueMinimo,
            'quantidadeParaEstoqueMinimo' => $this->quantidadeParaEstoqueMinimo,
        ]);
    }
}


