<?php
namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;
use App\Services\DateRangeService;
use Illuminate\Support\Facades\DB;

class QtdPedidoDieselComponent extends Component
{
    public $pedidosDieselMesAtual;
    public $pedidosDieselMesPassado;
    public $totalPedidosDieselMesAtual;
    public $totalPedidosDieselMesPassado;
    public $percentualPedidosDieselMudanca;

    public $datarange;
    public $idempresa;
    public $idveiculo;
    public $idcontrato;

    protected $listeners = ['filtersApplied' => 'onFilterUpdate'];

    public function mount()
    {
        $this->loadInitialData();
    }

    private function loadInitialData()
    {
        // Define o intervalo de datas inicial se nenhum datarange for fornecido
        if (empty($this->datarange)) {
            $this->setInitialDateRange();
        }
        $this->loadData();
    }

    private function setInitialDateRange()
    {
        $dataInicio = Carbon::now()->startOfMonth()->format('d-m-Y');
        $dataFim = Carbon::now()->format('d-m-Y');
        $this->datarange = $dataInicio . ' até ' . $dataFim;
    }


    private function loadData()
    {
        $dates = DateRangeService::generateDateRange($this->datarange);
        $query = Nf::pedido()
            ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
            ->whereIn('idprodserv', [20, 31])
            ->whereBetween('dataentrada', [$dates['dataInicio'], $dates['dataFim']]);

        if ($this->idempresa) {
            $query->where('nf.idempresa', $this->idempresa);
        }

        if (!empty($this->idcontrato)) {
            $query->whereExists(function ($subquery) {
                $subquery->select(DB::raw(1))
                    ->from('contratoveiculo as cv')
                    ->whereColumn('cv.idveiculo', 'nf.idveiculo')
                    ->where('cv.idcontrato', $this->idcontrato);
            });
        }

        if ($this->idveiculo) {
            $query->where('nf.idveiculo', $this->idveiculo);
        }

        $this->pedidosDieselMesAtual = $query->get();
        $this->totalPedidosDieselMesAtual = $this->pedidosDieselMesAtual->sum('qtd');

        // Faça a mesma coisa para o mês passado, ajustando as datas
    }

    public function render()
    {
        return view('livewire.qtd-pedido-diesel-component', [
            'pedidosDieselMesAtual' => $this->pedidosDieselMesAtual,
            'totalPedidosDieselMesAtual' => $this->totalPedidosDieselMesAtual,
            // Outras propriedades
        ]);
    }

    public function onFilterUpdate($filters)
    {
        $this->datarange = $filters['datarange'] ?? null;
        $this->idempresa = $filters['idempresa'] ?? null;
        $this->idveiculo = $filters['idveiculo'] ?? null;
        $this->idcontrato = $filters['idcontrato'] ?? null;
        $this->loadData();
    }
}
