<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class AdminTenantMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = Auth::user(); // Ou outra forma de pegar o tenant autenticado

        if ($user && $user->tenant->is_admin_tenant == 1) {
            return $next($request); // Permite o acesso se for admin
        }

        // Redireciona ou retorna erro se não for admin
        return redirect()->route('dashboard.financeiro')->with('error', 'Acesso negado.');
    }
}
