<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class VeiculoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array
	 */
	public function rules()
	{
		$rules = [
			'name'                 => 'required|max:100',
			'email'                => 'required|max:100',
			'phone'                => 'sometimes|nullable|string|max:20',
			'subject'              => 'required|max:100',
			'message'              => 'required|max:2000',
			'g-recaptcha-response' => [
				Rule::requiredIf(config('captcha.enable', SimNaoEnum::NAO) == SimNaoEnum::SIM),
				'captcha']
		];

		return $rules;
	}

	public function attributes()
	{
		return [
			'name'                 => 'Nome',
			'email'                => 'E-mail',
			'phone'                => 'Telefone',
			'subject'              => 'Assunto',
			'message'              => 'Mensagem',
			'g-recaptcha-response' => 'Captcha'
		];
	}

	public function messages()
	{
		return [];
	}

	public function sanitizers()
	{
		return [
			'name'    => 'trim|string',
			'email'   => 'trim|email',
			'phone'   => 'trim|string',
			'subject' => 'trim|string',
			'message' => 'trim|string',
		];
	}
}
