<?php

namespace App\Models;

use App\Scopes\TenantScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Agenda extends Model
{
    use HasFactory;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'agendas';
    protected $primaryKey = 'idagenda';

    protected $fillable = [
        'idempresa',
        'idpessoa',
        'nome',
        'tempo',
        'antecedenciaminima',
        'choquehorario',
        'coletiva',
        'online',
        'feriado',
        'seg_horainicio1',
        'seg_horafim1',
        'seg_horainicio2',
        'seg_horafim2',
        'ter_horainicio1',
        'ter_horafim1',
        'ter_horainicio2',
        'ter_horafim2',
        'qua_horainicio1',
        'qua_horafim1',
        'qua_horainicio2',
        'qua_horafim2',
        'qui_horainicio1',
        'qui_horafim1',
        'qui_horainicio2',
        'qui_horafim2',
        'sex_horainicio1',
        'sex_horafim1',
        'sex_horainicio2',
        'sex_horafim2',
        'sab_horainicio1',
        'sab_horafim1',
        'sab_horainicio2',
        'sab_horafim2',
        'dom_horainicio1',
        'dom_horafim1',
        'dom_horainicio2',
        'dom_horafim2',
        'horainicio1',
        'horafim1',
        'horainicio2',
        'horafim2',
        'status',
    ];

    protected $casts = [
        'criadoem' => 'datetime',
        'alteradoem' => 'datetime',
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    // Método para verificar se a coluna existe na tabela
    public static function hasColumn($column)
    {
        return in_array($column, (new static)->getFillable());
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'idempresa');
    }

    public function pessoa()
    {
        return $this->belongsTo(Pessoa::class, 'idpessoa');
    }

    public function agendaEventosTipos()
    {
        return $this->hasMany(AgendaEventoTipo::class, 'idagenda', 'idagenda');
    }
}
