<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AgendaEventoTipo extends Model
{
    use HasFactory;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'agenda_evento_tipos';
    protected $primaryKey = 'idagendaeventotipo';

    protected $fillable = [
        'idagenda',
        'ideventotipo',
    ];

    // Relacionamentoss
    public function agenda()
    {
        return $this->belongsTo(Agenda::class, 'idagenda');
    }

    public function eventoTipo()
    {
        return $this->belongsTo(EventoTipo::class, 'ideventotipo');
    }
}
