<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class Empresa extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'empresa';
    protected $primaryKey = 'idempresa';
    protected $fillable = [
        'idtenant',
        'razaosocial',
        'nomefantasia',
        'sigla',
        'cnpj',
        'inscestadual',
        'cep',
        'endereco',
        'numero',
        'complemento',
        'bairro',
        'cidade',
        'estado',
        'status',
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    // Método para verificar se a coluna existe na tabela
    public static function hasColumn($column)
    {
        return in_array($column, (new static)->getFillable());
    }

    public function scopeActive(Builder $query)
    {
        $query->where('status', 'ATIVO');
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function agencia()
    {
        return $this->hasMany(Agencia::class);
    }
}
