<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class EventoPessoa extends Model
{
    use HasFactory, HandlesFileUploads;

    protected $primaryKey = 'ideventopessoa';
    protected $fillable = [
        'idevento',
        'idpessoa',
        'idempresa',
        'status',
        'visualizado',
        'oculto'
    ];

    public function evento()
    {
        return $this->belongsTo(Evento::class, 'idevento');
    }

    public function pessoa()
    {
        return $this->belongsTo(Pessoa::class, 'idpessoa');
    }

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    // Método para verificar se a coluna existe na tabela
    public static function hasColumn($column)
    {
        return in_array($column, (new static)->getFillable());
    }   
}
