<?php

namespace App\Models;

use App\Scopes\TenantScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Funcionalidade extends Model
{
    use HasFactory;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'funcionalidades';
    protected $primaryKey = 'idfuncionalidade';
    protected $fillable = [
        'nome',
        'alias',
        'quantitativo',
        'status'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public static function hasColumn($column)
    {
        return in_array($column, (new static)->getFillable());
    }
}
