<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\{HasOne, BelongsTo};
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class Nf extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'nf';
    protected $primaryKey = 'idnf';
    protected $fillable = [
        'idpessoa',
        'idempresa',
        'idprodservtipo',
        'idveiculo',
        'idagencia',
        'km',
        'kmhist',
        'saida',
        'tipo',
        'dataemissao',
        'dataentrada',
        'idformapagamento',
        'qtdparcela',
        'status',
        'datainicio',
        'datafim',
        'valornf',
        'descontonf',
        'datavencimento',
        'nfe',
        'transferkey',
        'chavepix',
        'qrcodeurl',
        'totalnf',
        'observacao',
        'criadopor',
        'alteradopor',
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

     // Método para verificar se a coluna existe na tabela
     public static function hasColumn($column)
     {
         return in_array($column, (new static)->getFillable());
     }

    function formaPagamento()
    {
        return $this->hasOne(FormaPagamento::class, 'idformapagamento', 'idformapagamento');
    }
    public function prodservtipo()
    {
        return $this->hasOne(TipoProdutoServico::class, 'idprodservtipo', 'idprodservtipo');
    }

    function fornecedor()
    {
        return $this->hasOne(Pessoa::class, 'idpessoa', 'idpessoa');
    }

    function cliente()
    {
        return $this->hasOne(Pessoa::class, 'idpessoa', 'idpessoa');
    }

    function nfitem()
    {
        return $this->hasMany(NfItem::class, 'idnf', 'idnf');
    }

    function parcela()
    {
        return $this->hasMany(NfParcela::class, 'idnf', 'idnf');
    }

    public function parcelaWithoutGlobalScope()
    {
        return $this->hasMany(NfParcela::class, 'idnf', 'idnf')->withoutGlobalScope(TenantScope::class);
    }

    public function nfitemWithoutGlobalScope()
    {
        return $this->hasMany(NfItem::class, 'idnf', 'idnf')->withoutGlobalScope(TenantScope::class);
    }


    public function pessoa() : HasOne
    {
        return $this->hasOne(Pessoa::class, 'idpessoa', 'idpessoa');
    }

    public function empresa() : HasOne
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }

    public function veiculo() : HasOne
    {
        return $this->hasOne(Veiculo::class, 'idveiculo', 'idveiculo');
    }

    public function scopeCompra(Builder $query): void
    {
        $query->where('tipo', 'D');
    }

    public function scopePedido(Builder $query): void
    {
        $query->where('tipo', 'C')
            ->where('saida', 'P');
    }
    public function scopeVenda(Builder $query): void
    {
        $query->where('tipo', 'C')
            ->where('saida', 'V');
    }

    public function agencia() : BelongsTo
    {
        return $this->belongsTo(Agencia::class, 'idagencia', 'idagencia');
    }
}
