<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder; // Corrigindo o namespace
use Illuminate\Database\Eloquent\Relations\{BelongsTo, HasOne};
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;


class NfParcela extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'nfparcela';
    protected $primaryKey = 'idnfparcela';

    protected $fillable = [
        'idnf',
        'idagencia',
        'idempresa',
        'idpessoa',
        'tipo',
        'parcela',
        'valor',
        'datavencimento',
        'datatransacao',
        'status',
        'saldoinicial',
        'saldoatual',
        'idtransacao',
        'localtransacao',
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

     // Método para verificar se a coluna existe na tabela
     public static function hasColumn($column)
     {
         return in_array($column, (new static)->getFillable());
     }

    function nf()
    {
        return $this->belongsTo(Nf::class, 'idnf', 'idnf');
    }
    public function empresa() : BelongsTo
    {
        return $this->belongsTo(Empresa::class, 'idempresa', 'idempresa');
    }
    public function scopeAtivo(Builder $query): void
    {
        $query->where('status', 'ATIVO');
    }
    public function scopeConcluido(Builder $query): void
    {
        $query->where('status', 'CONCLUÍDO');
    }

    public function scopeCredito(Builder $query): void
    {
        // F: fornecedor
        $query->where('tipo', 'C');
    }

    public function scopeDebito(Builder $query): void
    {
        // F: fornecedor
        $query->where('tipo', 'D');
    }

    public function scopeNaoPedido(Builder $query): void
    {
        $query->whereNotExists(function($subQuery) {
            $subQuery->select(DB::raw(1))
                     ->from('nf as n')
                     ->where('n.tipo', 'C')
                     ->where('n.saida', 'P')
                     ->whereColumn('n.idnf', 'nfparcela.idnf'); // Certifique-se de que 'idnf' é a coluna correta
        });
    }

    public function agencia() : BelongsTo
    {
        return $this->belongsTo(Agencia::class, 'idagencia', 'idagencia');
    }
}
