<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class Pessoa extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'pessoa';
    protected $primaryKey = 'idpessoa';
    protected $fillable = [
        'idempresa',
        'idrepresentante',
        'nome',
        'razaosocial',
        'cpfcnpj',
        'inscestadual',
        'cep',
        'endereco',
        'numero',
        'complemento',
        'bairro',
        'cidade',
        'estado',
        'responsavel',
        'telefone',
        'celular',
        'celular2',
        'datanascimento',
        'rg',
        'nomepai',
        'nomemae',
        'estadocivil',
        'cargo',
        'admissao',
        'admissaomotivo',
        'demissao',
        'demissaomotivo',
        'email',
        'website',
        'descricao',
        'observacao',
        'temagenda',
        'status',
        'tipo',
        'pessoapadrao',
        'cor',
        'criadopor',
        'alteradopor'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    // Método para verificar se a coluna existe na tabela
    public static function hasColumn($column)
    {
        return in_array($column, (new static)->getFillable());
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('status', 'ATIVO');
    }

    public function scopeFornecedor(Builder $query): void
    {
        // F: fornecedor
        $query->where('tipo', 'fornecedor');
    }

    public function scopeCliente(Builder $query): void
    {
        $query->where('tipo', 'cliente');
    }

    public function scopeFuncionario(Builder $query): void
    {
        $query->where('tipo', 'F');
    }

    public function scopeFuncionarioOuCliente(Builder $query): void
    {
        $query->where(function ($query) {
            $query->where('tipo', 'F')
                ->orWhere('tipo', 'cliente');
        });
    }

    public function scopeRepresentante(Builder $query): void
    {
        $query->where('tipo', 'R');
    }

    // public function tipo()
    // {
    //     return $this->hasOne(TipoPessoa::class, 'idtipopessoa', 'idtipopessoa');
    // }

    public function empresa()
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }

    public function representante()
    {
        return $this->hasOne(Pessoa::class, 'idpessoa', 'idrepresentante');
    }
}
