<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class ProdutoServico extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'prodserv';
    protected $primaryKey = 'idprodserv';
    protected $fillable = [
        'idprodservtipo',
        'idempresa',
        'tipo',
        'prodserv',
        'status',
        'valorcompra',
        'valorvenda',
        'unidade',
        'estoqueminimo',
        'criadopor',
        'alteradopor'
    ];

    public function eventotipo()
    {
        return $this->hasMany(EventoTipo::class, 'ideventotipo');
    }

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

     // Método para verificar se a coluna existe na tabela
     public static function hasColumn($column)
     {
         return in_array($column, (new static)->getFillable());
     }


    public function tipos()
    {
        return $this->belongsToMany(TipoProdutoServico::class, 'prodserv_prodservtipo', 'idprodserv', 'idprodservtipo')
                    ->withTimestamps('criadoem', 'alteradoem');
    }

    public function prodservtipo()
    {
        return $this->belongsTo(TipoProdutoServico::class, 'idprodservtipo');
    }

    public function empresa() : HasOne
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }


}
