<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class TipoProdutoServico extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'prodservtipo';
    protected $primaryKey = 'idprodservtipo';

    protected $fillable = [
        'idempresa',
        'prodservtipo',
        'padrao',
        'status',
        'criadopor',
        'criadoem',
        'alteradopor',
        'alteradoem'
    ];

    public function produtos()
    {
        return $this->belongsToMany(ProdutoServico::class, 'prodserv_prodservtipo', 'idprodservtipo', 'idprodserv')
                    ->withTimestamps('criadoem', 'alteradoem');
    }

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

     // Método para verificar se a coluna existe na tabela
     public static function hasColumn($column)
     {
         return in_array($column, (new static)->getFillable());
     }

    public function empresa() : HasOne
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }

    public function scopeActive(Builder $query)
    {
        $query->where('status', 'ATIVO');
    }
}
