<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Scopes\TenantScope;

class Upload extends Model
{
    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';
    
    protected $table = 'upload';
    protected $primaryKey = 'idupload';
    protected $fillable = ['idtenant','idempresa','objeto', 'idobjeto', 'caminho', 'criadopor', 'criadoem', 'alteradopor', 'alteradoem'];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

     // Método para verificar se a coluna existe na tabela
     public static function hasColumn($column)
     {
         return in_array($column, (new static)->getFillable());
     }
    
    public function uploadable()
    {
        return $this->morphTo('objeto', 'idobjeto');
    }
}