<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Contracts\Auth\CanResetPassword;
use Spatie\Permission\Traits\HasRoles;
use App\Scopes\TenantScope;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'username',
        'idtenant',
        'idsession',
        'status',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'last_login_at' => 'datetime',
    ];

    public function setPasswordAttribute($password)
    {
        $this->attributes['password'] = bcrypt($password);
    }

    public function getAll($return = 'get', $paginate = '*')
    {
        if(strpos($paginate, ','))
        {
            list($param1, $param2) = explode(',', $paginate);
            str_replace(' ', '', $param1);
            str_replace(' ', '', $param2);

            return $this->latest()
                    ->$return($param1, $param2);
        }

        return $this->latest()
                    ->$return($paginate);
    }

    public function filter($filters = false, $return = 'get', $paginate = '*')
    {
        if($filters)
        {
            return $this->latest()
                    ->where($filters['filter'], 'like', '%'.$filters['query'].'%')
                    ->$return($paginate);
        } else
        {
            return $this->getAll($return, $paginate);
        }
    }

    public function scopeActive(Builder $query)
    {
        $query->where('status', 'ATIVO');
    }

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

     // Método para verificar se a coluna existe na tabela
     public static function hasColumn($column)
     {
         return in_array($column, (new static)->getFillable());
     }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class, 'idtenant', 'idtenant');
    }

    public function representante()
    {
        return $this->belongsTo(Pessoa::class, 'idrepresentante', 'idpessoa')->withDefault();
    }

}
