<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Veiculo extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $primaryKey = 'idveiculo';
    protected $table = 'veiculo';
    protected $fillable = [
        'idempresa',
        'idpessoa',
        'idcontrato',
        'tipoveiculo',
        'ano',
        'marca',
        'modelo',
        'placa',
        'renavan',
        'chassi',
        'km',
        'cor',
        'sigla',
        'rastreador',
        'crv',
        'status',
        'idseguradora',
        'apolice',
        'datavencimento',
        'dashboard'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

     // Método para verificar se a coluna existe na tabela
     public static function hasColumn($column)
     {
         return in_array($column, (new static)->getFillable());
     }

    public function pessoa() : HasOne
    {
        return $this->hasOne(Pessoa::class, 'idpessoa', 'idpessoa');
    }

    public function seguradora() : HasOne
    {
        return $this->hasOne(Pessoa::class, 'idpessoa', 'idseguradora');
    }

    public function empresa() : HasOne
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }

    public function pedido() : HasMany
    {
        return $this->hasMany(Nf::class, 'idveiculo', 'idveiculo');
    }

    public function contrato() : HasOne
    {
        return $this->hasOne(Contrato::class, 'idcontrato', 'idcontrato');
    }

    public function contratoVeiculo() : HasMany
    {
        return $this->hasMany(ContratoVeiculo::class, 'idveiculo', 'idveiculo');
    }

    public function scopeAtivo(Builder $query): void
    {
        $query->where('status', 'Ativo');
    }

    // Definindo um scope para filtrar veículos com dashboard = 1
    public function scopeWithDashboard($query)
    {
        return $query->where('dashboard', 1);
    }
}
