<?php

namespace App\Services;

use App\Models\ContratoItem;
use Exception;
use Illuminate\Support\Facades\Log;

class ContratoService
{
    public function __construct(
        protected NfService $nfService
    ) {}

    public function processarRecorrencias($contrato)
    {
        try {
            // Determina o tipo de contrato (compra ou venda)
            $nf = ($contrato->tipo == 'C')
                ? $this->gerarVenda($contrato)
                : $this->gerarCompra($contrato);

            // Atualiza a data da próxima recorrência
            $contrato->dataultimarecorrencia = $contrato->getProximaDataRecorrencia();
            $contrato->save();

            // Verifica se o contrato tem data da primeira recorrencia
            if (!isset($contrato->dataultimarecorrencia) || !isset($contrato->idcontrato)) {
                return;
            }

            // Gera a primeira parcela
            $this->gerarParcela($nf, $contrato);

            // Gera a nfitems da primeira parcela
            $this->gerarNfItems($nf, $contrato);

            return $nf;
        } catch (Exception $e) {
            // Logando o erro para uma melhor rastreabilidade
            Log::error("Erro ao gerar a nf: {$e->getMessage()}");
        }
    }

    private function gerarVenda($contrato)
    {
        try {
            // Chama o serviço para gerar a nf
            $nf = $this->nfService->store($contrato);
            return $nf;
        } catch (Exception $e) {
            Log::error("Erro ao gerar a nf: {$e->getMessage()}");
        }
    }

    private function gerarCompra($contrato)
    {
        try {
            // Chama o serviço para gerar a nf
            $nf = $this->nfService->store($contrato);
            return $nf;
        } catch (Exception $e) {
            Log::error("Erro ao gerar a nf: {$e->getMessage()}");
        }
    }

    private function gerarParcela($nf)
    {
        try {
            // Chama o serviço para gerar as parcelas
            $this->nfService->handleParcels($nf);
        } catch (Exception $e) {
            Log::error("Erro ao gerar as parcelas: {$e->getMessage()}");
        }
    }

    private function gerarNfItems($nf, $contrato)
    {
        // Recupera o item do contrato
        $contratoItem = ContratoItem::where('idcontrato', $contrato->idcontrato)->first();

        // Verifica se o contratoItem foi encontrado
        if (! $contratoItem) {
            Log::error('ContratoItem não encontrado');
        }

        try {
            // Chama o serviço para registrar os itens vinculados ao contratoitem na tabela nfitem
            $this->nfService->storeNfItem($contrato->idcontrato, $nf);
        } catch (\Exception $e) {
            Log::error("Erro ao registrar os itens vinculados ao contratoitem na tabela nfitem: {$e->getMessage()}");
        }
    }
}
