<?php

namespace App\Services;

use Carbon\Carbon;

class DateRangeService
{

    public static function generateDateRange($datarange)
    {
        $dataInicio = null;
        $dataFim = null;
        
        $intervaloDatas = explode(' até ', $datarange);
        
        if (isset($datarange) && count($intervaloDatas) == 2) {
            $dataInicio = Carbon::createFromFormat('d-m-Y', $intervaloDatas[0])->startOfDay();
            $dataFim = Carbon::createFromFormat('d-m-Y', $intervaloDatas[1])->endOfDay();
        } else {
            $dataInicio = Carbon::now()->startOfMonth()->startOfDay();
            $dataFim = Carbon::now()->endOfMonth()->endOfDay();
            $datarange = $dataInicio->format('d-m-Y') . " até " . $dataFim->format('d-m-Y');
        }

        // Preenche todos os dias no intervalo
        $periodo = new \DatePeriod(
            $dataInicio,
            new \DateInterval('P1D'),
            $dataFim->copy()->addDay()  // Ajusta o período para incluir o último dia
        );

        $dataDiff = $dataInicio->diffInDays($dataFim);

        $dadosDiasArray = [];

        foreach ($periodo as $date) {
            $dadosDiasArray[] = [
                'data' => $date->format('Y-m-d'),
                'total' => 0
            ];
        }

        return ['datarange' => $datarange, 'dadosDiasArray' => $dadosDiasArray, 'dataInicio' => $dataInicio, 'dataFim' => $dataFim, 'dataDiff' => $dataDiff ];
    }
}
