<?php

namespace App\Services;

use App\Models\Empresa;
use App\Models\Tag;

class TagService
{
    /**
     * Gera o próximo número sequencial para uma empresa.
     *
     * @param int $idempresa
     * @return string
     */
    public function generateTagNumber($idempresa)
    {
        // Recupera a última tag gerada para a empresa
        $lastTag = Tag::where('idempresa', $idempresa)
            ->orderBy('tag', 'desc')
            ->first();

        // Se não houver tags, começa com 1
        if (!$lastTag) {
            $newTag = 1;
        } else {
            // Tratamento para extrair a parte numérica da última tag
            $numericPart = preg_replace('/[^0-9]/', '', $lastTag->tag); // Remove tudo que não é número
            $newTag = (int)$numericPart + 1;
        }

        // Recupera o prefixo (sigla) da empresa
        $prefix = Empresa::find($idempresa)->sigla;

        // Gera a nova tag no formato 'prefixo-numero'
        $tag = "$prefix-$newTag";

        // Retorna a nova tag gerada
        return $tag;
    }
}
