<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('obras', function (Blueprint $table) {
            $table->id();
            $table->int('idempresa');
            $table->foreign('idempresa')->references('idempresa')->on('empresa');
            $table->int('idpessoa');
            $table->foreign('idpessoa')->references('idpessoa')->on('pessoa');
            $table->string('cep', 45);
            $table->string('endereco', 45);
            $table->string('numero', 45);
            $table->string('complemento', 45);
            $table->string('bairro', 45);
            $table->string('cidade', 45);
            $table->string('estado', 45);
            $table->string('status', 45);
            $table->string('criadopor', 45);
            $table->string('alteradopor', 45);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('obras');
    }
};
