<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('empresa', function (Blueprint $table) {
            $table->id('idempresa');
            $table->string('razaosocial', 120);
            $table->string('cnpj', 45);
            $table->string('inscestadual', 45);
            $table->string('cep', 45);
            $table->string('endereco', 45);
            $table->string('numero', 45);
            $table->string('complemento', 45);
            $table->string('bairro', 45);
            $table->string('cidade', 45);
            $table->string('estado', 45);
            $table->string('status', 45);
            $table->timestamp('criadoem')->useCurrent();
            $table->string('criadopor', 45)->nullable();
            $table->timestamp('alteradoem')->useCurrent();
            $table->string('alteradopor', 45)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('empresa');
    }
};
