<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prodservtipo', function (Blueprint $table) {
            $table->id('idprodservtipo');
            $table->unsignedBigInteger('idempresa');
            $table->foreign('idempresa')->references('idempresa')->on('empresa');
            $table->string('prodservtipo', 120);
            $table->string('tipo', 45);
            $table->string('status', 45);
            $table->timestamp('criadoem')->useCurrent();
            $table->string('criadopor', 45)->nullable();
            $table->timestamp('alteradoem')->useCurrent();
            $table->string('alteradopor', 45)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prodservtipo');
    }
};
