<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('nfparcela', function (Blueprint $table) {
            $table->id('idnfparcela');
            $table->unsignedBigInteger('idnf');
            $table->foreign('idnf')->references('idnf')->on('nf');
            $table->integer('parcela');
            $table->decimal('valor', 10, 2);
            $table->string('status', 45);
            $table->timestamp('criadoem')->useCurrent();
            $table->string('criadopor', 45)->nullable();
            $table->timestamp('alteradoem')->useCurrent();
            $table->string('alteradopor', 45)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nfparcela');
    }
};
