<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tag', function (Blueprint $table) {
            $table->bigIncrements('idtag'); // Campo idtag com auto incremento e chave primária
            $table->unsignedBigInteger('idtagtipo')->nullable(); // Chave estrangeira idtagtipo, permite nulo
            $table->unsignedBigInteger('idempresa'); // Chave estrangeira idempresa
            $table->string('tag', 8); // Campo tag
            $table->string('nome', 120); // Campo nome
            $table->text('descricao'); // Campo descricao
            $table->string('status', 45); // Campo status
            $table->timestamp('criadoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo criadoem com valor default
            $table->string('criadopor', 45)->nullable(); // Campo criadopor, permite nulo
            $table->timestamp('alteradoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo alteradoem com valor default
            $table->string('alteradopor', 45)->nullable(); // Campo alteradopor, permite nulo

            // Definindo as chaves estrangeiras
            $table->foreign('idempresa')->references('idempresa')->on('empresa')->onDelete('cascade');
            $table->foreign('idtagtipo')->references('idtagtipo')->on('tagtipo')->onDelete('set null');

            // Definindo índices
            $table->index('idtagtipo', 'tag_idtagtipo_foreign');
            $table->index('idempresa', 'tag_idempresa_foreign');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Excluindo as chaves estrangeiras e índices
        Schema::table('tag', function (Blueprint $table) {
            $table->dropForeign('tag_idempresa_foreign');
            $table->dropForeign('tag_idtagtipo_foreign');
            $table->dropIndex('tag_idempresa_foreign');
            $table->dropIndex('tag_idtagtipo_foreign');
        });

        Schema::dropIfExists('tag');
    }
};
