<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tag', function (Blueprint $table) {
            $table->dropColumn('nome');
            $table->dropColumn('descricao');

            $table->unsignedBigInteger('idnf')->nullable();
            $table->string('marca')->nullable();
            $table->string('modelo')->nullable();;
            $table->string('anofabricacao')->nullable();;
            $table->string('numeroserie')->nullable();;
            $table->string('altura')->nullable();;
            $table->string('largura')->nullable();;
            $table->string('comprimento')->nullable();;
            $table->string('peso')->nullable();
            $table->string('material')->nullable();;
            $table->string('combustivel')->nullable();;
            $table->timestamp('datamanutencao')->nullable();;
            $table->timestamp('dataproximamanutencao')->nullable();;
            $table->string('garantia')->nullable();;
            $table->string('voltagem')->nullable();;
            $table->string('processador')->nullable();;
            $table->string('memoriaram')->nullable();;
            $table->string('cor')->nullable();
            $table->string('sistemaoperacional')->nullable();;
            $table->string('observacao')->nullable();;

            $table->foreign('idnf')->references('idnf')->on('nf');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tag', function (Blueprint $table) {
            $table->string('nome')->nullable();
            $table->string('descricao')->nullable();

            $table->dropForeign(['idnf']);
            $table->dropColumn('idnf');

            $table->dropColumn('marca');
            $table->dropColumn('modelo');
            $table->dropColumn('anofabricacao');
            $table->dropColumn('numeroserie');
            $table->dropColumn('altura');
            $table->dropColumn('largura');
            $table->dropColumn('comprimento');
            $table->dropColumn('peso');
            $table->dropColumn('material');
            $table->dropColumn('combustivel');
            $table->dropColumn('datamanutencao');
            $table->dropColumn('dataproximamanutencao');
            $table->dropColumn('garantia');
            $table->dropColumn('voltagem');
            $table->dropColumn('processador');
            $table->dropColumn('memoriaram');
            $table->dropColumn('cor');
            $table->dropColumn('sistemaoperacional');
            $table->dropColumn('observacao');
        });
    }
};
