<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('funcionalidades', function (Blueprint $table) {
            $table->id('idfuncionalidade');
            $table->string('nome');
            $table->string('alias');
            $table->string('status');
            $table->timestamp('criadoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo criadoem com valor default
            $table->string('criadopor', 45)->nullable(); // Campo criadopor, permite nulo
            $table->timestamp('alteradoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo alteradoem com valor default
            $table->string('alteradopor', 45)->nullable(); // Campo alteradopor, permite nulo
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('funcionalidades');
    }
};
