<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop antiga agenda
        Schema::dropIfExists('agendas');

        // Nova estrutura da agenda
        Schema::create('agendas', function (Blueprint $table) {
            $table->id('idagenda');
            $table->unsignedBigInteger('idempresa');
            $table->unsignedBigInteger('idpessoa')->nullable();
            $table->string('nome');
            $table->string('tempo')->nullable();
            $table->string('antecedenciaminima')->nullable();
            $table->integer('choquehorario')->nullable();
            $table->boolean('coletiva')->default(false);
            $table->boolean('online')->default(false);
            $table->boolean('feriado')->default(false);
            $table->time('seg_horainicio1')->nullable();
            $table->time('seg_horafim1')->nullable();
            $table->time('seg_horainicio2')->nullable();
            $table->time('seg_horafim2')->nullable();
            $table->time('ter_horainicio1')->nullable();
            $table->time('ter_horafim1')->nullable();
            $table->time('ter_horainicio2')->nullable();
            $table->time('ter_horafim2')->nullable();
            $table->time('qua_horainicio1')->nullable();
            $table->time('qua_horafim1')->nullable();
            $table->time('qua_horainicio2')->nullable();
            $table->time('qua_horafim2')->nullable();
            $table->time('qui_horainicio1')->nullable();
            $table->time('qui_horafim1')->nullable();
            $table->time('qui_horainicio2')->nullable();
            $table->time('qui_horafim2')->nullable();
            $table->time('sex_horainicio1')->nullable();
            $table->time('sex_horafim1')->nullable();
            $table->time('sex_horainicio2')->nullable();
            $table->time('sex_horafim2')->nullable();
            $table->time('sab_horainicio1')->nullable();
            $table->time('sab_horafim1')->nullable();
            $table->time('sab_horainicio2')->nullable();
            $table->time('sab_horafim2')->nullable();
            $table->time('dom_horainicio1')->nullable();
            $table->time('dom_horafim1')->nullable();
            $table->time('dom_horainicio2')->nullable();
            $table->time('dom_horafim2')->nullable();
            $table->time('horainicio1')->nullable();
            $table->time('horafim1')->nullable();
            $table->time('horainicio2')->nullable();
            $table->time('horafim2')->nullable();
            $table->string('status');

            $table->timestamp('criadoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo criadoem com valor default
            $table->string('criadopor', 45)->nullable(); // Campo criadopor, permite nulo
            $table->timestamp('alteradoem')->default(DB::raw('CURRENT_TIMESTAMP')); // Campo alteradoem com valor default
            $table->string('alteradopor', 45)->nullable(); // Campo alteradopor, permite nulo
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('agendas');
    }
};
