
    document.addEventListener('DOMContentLoaded', function () {
        const now = new Date();
        const startOfMonth = new Date(now.getFullYear(), now.getMonth(), 1);
        const endOfMonth = new Date(now.getFullYear(), now.getMonth() + 1, 0);
        const today = new Date();

        flatpickr("#datePicker", {
            mode: "range",
            dateFormat: "d-m-Y",
            defaultDate: [startOfMonth, today],
            minDate: "01-01-1900", // Por exemplo, mínimo em 1 de janeiro de 1900
            maxDate: "31-12-2099", // Por exemplo, máximo em 31 de dezembro de 2099
            "locale": {
                "firstDayOfWeek": 0, // Define segunda-feira como primeiro dia da semana
                "weekdays": {
                    "shorthand": ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"],
                    "longhand": ["Domingo", "Segunda", "Terça", "Quarta", "Quinta", "Sexta", "Sábado"],         
                }, 
                "months": {
                    "shorthand": ["Jan", "Fev", "Mar", "Abr", "Mai", "Jun", "Jul", "Ago", "Set", "Out", "Nov", "Dez"],
                    "longhand": ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"]
                },
                "rangeSeparator": " até ",
                "daysInMonth": [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
                "ordinal": function () {
                    return "º";
                }
            },
            onChange: function(selectedDates, dateStr, instance) {
                const event = new CustomEvent('date-range-selected', { detail: { dateRange: dateStr } });
                window.dispatchEvent(event);
            }
        });
    });
