$(document).ready(function () {
    // Verificação inicial para esconder o campo de quantidade se a funcionalidade inicial não for quantitativa
    const initialQuantitative = $("#idfuncionalidade")
        .find("option:selected")
        .data("isquantitative");
    const planoContainer = $("#container-plano");
    const funcionalidadeContainer = $("#container-funcionalidade");
    const quantidadeContainer = $("#container-qtd");
    const selectFuncionalidade = $("#idfuncionalidade");
    const inputQuantidade = $("#input-qtd");

    // Mostra ou esconde o campo de quantidade com base no valor inicial
    toggleQuantidadeField(initialQuantitative);

    // Função para verificar se a funcionalidade selecionada é quantitativa e habilitar ou desabilitar o campo de quantidade
    selectFuncionalidade.on("change", function () {
        const isQuantitative = $(this)
            .find("option:selected")
            .data("isquantitative");
        console.log(isQuantitative);
        // Chama a função para mostrar ou esconder o campo com base na seleção
        toggleQuantidadeField(isQuantitative);
    });

    // Função que mostra ou esconde o campo de quantidade
    function toggleQuantidadeField(isQuantitative) {
        if (isQuantitative === 1) {
            console.log("entrou aqui");
            planoContainer.removeClass("col-md-6").addClass("col-md-4");
            funcionalidadeContainer
                .removeClass("col-md-6")
                .addClass("col-md-4");
            quantidadeContainer.removeClass("d-none").addClass("d-block");
            inputQuantidade.prop("required", true);
        } else {
            quantidadeContainer.removeClass("d-block").addClass("d-none");
            planoContainer.removeClass("col-md-4").addClass("col-md-6");
            funcionalidadeContainer
                .removeClass("col-md-4")
                .addClass("col-md-6");
            inputQuantidade.prop("required", false);
        }
    }
});
