$(document).ready(function () {
    var hasReserved = false; // Variável global para controle do status "RESERVADA"
    var currentTagId = $("#idtag").val(); // ID da tag atual em edição

    $("#idempresa").on("change", function () {
        const idempresa = $(this).val();

        // Faz a requisição AJAX
        $.ajax({
            url: `/admin/pessoas/get/${idempresa}`,
            type: "GET",
            success: function (response) {
                // Limpa o select de pessoas
                $("#idpessoa").empty();
                $("#idpessoa").append(
                    '<option value="" disabled="disabled">- Selecionar -</option>'
                );

                // Popula o select de pessoas
                $.each(response.data, function (index, pessoa) {
                    $("#idpessoa").append(
                        '<option value="' +
                            pessoa.idpessoa +
                            '">' +
                            pessoa.nome +
                            "</option>"
                    );
                });
            },
            error: function (error) {
                console.log(error);
            },
        });
    });

    // Função para verificar e desabilitar o botão submit
    function checkSubmitButton() {
        var statusValue = $("#input-status").val();

        // Se já houver uma tag com status "RESERVADA" e a tag reservada não for a que está sendo editada
        if (hasReserved && statusValue === "RESERVADA") {
            // Verifica se a tag atual é a mesma que está reservada
            if (isCurrentTagReserved()) {
                $("#submit-button").prop("disabled", false); // Habilita o botão se for a mesma tag
            } else {
                $("#submit-button").prop("disabled", true); // Desabilita o botão se for outra tag reservada
            }
        } else {
            $("#submit-button").prop("disabled", false); // Habilita o botão se não houver outra tag reservada
        }
    }

    // Função para verificar se a tag atual está reservada
    function isCurrentTagReserved() {
        var isReserved = false;
        $("#table-tags-retiradas tbody tr").each(function () {
            var tagStatus = $(this).find("span.badge").text().trim();
            var tagId = $(this).data("tag-id"); // Obtém o ID da tag no tr

            if (tagId == currentTagId && tagStatus === "RESERVADA") {
                isReserved = true;
            }
        });
        return isReserved;
    }

    // Função para pegar as tags reservadas, aceitando o valor como parâmetro
    function getTagReservas(tagValue) {
        var route = `/admin/tagsretira/gettagreservadas/${tagValue}`;

        $.ajax({
            url: route,
            type: "GET",
            success: function (response) {
                // Limpa a tabela antes de preencher
                $("#table-tags-retiradas tbody").empty();

                // Reseta a variável hasReserved
                hasReserved = false;

                // Preenche a tabela com os dados retornados
                $.each(response.data, function (index, tag) {
                    var dataInicio = tag.datainicio
                        ? new Date(tag.datainicio).toLocaleDateString("pt-BR")
                        : "Não informado";
                    var dataFim = tag.datafim
                        ? new Date(tag.datafim).toLocaleDateString("pt-BR")
                        : "Não informado";

                    // Define a cor do badge com base no status
                    var badgeColor =
                        tag.status == "RESERVADA" ? "danger" : "warning";

                    var newRow = `
                        <tr data-tag-id="${tag.idtag}"> <!-- Armazena o ID da tag no tr -->
                            <td class="align-middle text-center">${tag.pessoa.nome}</td>
                            <td class="align-middle text-center">${dataInicio}</td>
                            <td class="align-middle text-center">${dataFim}</td>
                            <td class="align-middle text-center">
                                <span class="badge badge-sm bg-gradient-${badgeColor}">
                                    ${tag.status}</span>
                            </td>
                        </tr>
                    `;
                    $("#table-tags-retiradas tbody").append(newRow);

                    // Verifica se há algum status "RESERVADA" diferente da tag atual
                    if (
                        tag.status === "RESERVADA" &&
                        tag.idtag != currentTagId
                    ) {
                        hasReserved = true; // Marca como reservada apenas se não for a tag atual
                    }
                });

                // Após processar os dados da requisição, verifica o estado do botão submit
                checkSubmitButton();
            },
            error: function (error) {
                console.log(error);
            },
        });
    }

    // Quando o campo selecionado muda, chama a função para pegar as tags reservadas
    $("#idtag").change(function () {
        currentTagId = $(this).val(); // Atualiza a tag em edição
        getTagReservas(currentTagId);
    });

    // Chama a função para pegar as tags reservadas ao carregar o site
    var initialTagValue = $("#idtag").val();
    getTagReservas(initialTagValue);

    // Verifica o valor do status selecionado e habilita ou desabilita o botão
    $("#input-status").change(function () {
        checkSubmitButton();
    });
});
