@push('css')
    {{-- Select2 --}}
    <link rel="stylesheet" href="{{ asset('assets/css/select2.min.css') }}">
@endpush
<meta name="csrf-token" content="{{ csrf_token() }}">
<?php
 $opt = '';
if(isset($prodserv)){
    foreach($prodserv as $prod)
    {
            $opt .='<option value="'.$prod->idprodserv.'" data-unidade="'.$prod->unidade.'" data-valorcompra="'.$prod->valorcompra.'">'.htmlspecialchars($prod->prodserv).'</option>"';
    }
}

$grit = '';
if(isset($grupoItens)){
    foreach($grupoItens as $grupoitem)
    {
            $grit .='<option value="'.$grupoitem->idgrupoitem.'">'.htmlspecialchars($grupoitem->grupoitem).'</option>"';
    }
}

$it = '';
if(isset($listaItens)){
    foreach($listaItens as $listaItem)
    {
            $it .='<option data-idgrupoitem="'.$listaItem->idgrupoitem.'" data-item="'.$listaItem->item.'" value="'.$listaItem->iditem.'">'.htmlspecialchars($listaItem->item).'</option>"';
    }
}

?>
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Compras</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($compra))
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$compra->idnf;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$compra->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
            </div>
            <div class="col-md-12 col-lg-12">
                <div class="row">
                    {{-- Empresa --}}
                    <div class="col-9">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Empresa</label>
                            <select class="form-control" name="idempresa">
                                <option value="" disabled="disabled">- Selecionar -</option>
                            @foreach($empresas as $empresa)
                                <option value="{{ $empresa->idempresa }}" {{ ((isset($compra) && $empresa->idempresa == $compra->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Tipo --}}
                        <input type="hidden" name="tipo" value="D" />
                        <input type="hidden" name="saida" value="N" />

                    {{-- Data entrada --}}
                    <div class="col-3">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('dataentrada') ? ' is-invalid' : '' }}">
                            <label>{{ __('Data entrada') }}</label>
                            <input class="form-control {{ $errors->has('dataentrada') ? ' is-invalid' : '' }}"
                                name="dataentrada" id="input-dataentrada" type="date"
                                value="{{ isset($compra) ? $compra->dataentrada : date('Y-m-d') }}"
                                placeholder="{{ __('Data entrada') }}" />
                            @if ($errors->has('dataentrada'))
                                <span id="dataentrada-error" class="error text-danger"
                                    for="input-dataentrada">{{ $errors->first('dataentrada') }}</span>
                            @endif
                        </div>
                    </div>

                    {{-- Pessoa --}}
                    <div class="col-8">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Fornecedor</label>
                            <select class="form-control" name="idpessoa">
                                <option value="" disabled="disabled">- Selecionar -</option>
                                @foreach($pessoas as $pessoa)
                                    <option value="{{ $pessoa->idpessoa }}" {{ ((isset($compra) && $pessoa->idpessoa == $compra->idpessoa) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{ $pessoa->razaosocial ?? $pessoa->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Tipo de Produto e Serviço --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Tipo</label>
                            <select class="form-control" name="idprodservtipo" required="true" aria-required="true"
                           >
                                <option value="" disabled="disabled">- Selecionar -</option>
                                @foreach($tiposProdutoServico as $tipoProdutoServico)
                                    <option value="{{ $tipoProdutoServico->idprodservtipo }}" {{ ((isset($compra) && $tipoProdutoServico->idprodservtipo == $compra->idprodservtipo) || (old('idprodservtipo') == $tipoProdutoServico->idprodservtipo)) ? 'selected' : '' }}>{{$tipoProdutoServico->prodservtipo}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    {{-- Data de Inicio --}}
                    <div class="col-4 d-none">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('datainicio') ? ' is-invalid' : '' }}">
                            <label>{{ __('Data de Inicio') }}</label>
                            <input class="form-control {{ $errors->has('datainicio') ? ' is-invalid' : '' }}"
                                name="datainicio" id="input-datainicio" type="date"
                                value="{{ isset($compra) ? $compra->datainicio : old('datainicio') }}"
                                placeholder="{{ __('Data de Inicio') }}" />
                            @if ($errors->has('datainicio'))
                                <span id="datainicio-error" class="error text-danger"
                                    for="input-datainicio">{{ $errors->first('datainicio') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Data Final --}}
                    <div class="col-4 d-none">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('datafim') ? ' is-invalid' : '' }}">
                            <label>{{ __('Data Final') }}</label>
                            <input class="form-control {{ $errors->has('datafim') ? ' is-invalid' : '' }}"
                                name="datafim" id="input-datafim" type="date"
                                value="{{ isset($compra) ? $compra->datafim : old('datafim') }}"
                                placeholder="{{ __('Data Final') }}"  />
                            @if ($errors->has('datafim'))
                                <span id="datafim-error" class="error text-danger"
                                    for="input-datafim">{{ $errors->first('datafim') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados de Pagamento</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                        {{-- Forma Pagamento --}}
                            <div class="col-3">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Forma de Pagamento</label>
                                    <select class="form-control" name="idformapagamento">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach($formaPagamento as $pagamento)
                                            <option value="{{ $pagamento->idformapagamento }}" {{ ((isset($compra) && $pagamento->idformapagamento == $compra->idformapagamento) || (old('idformapagamento') == $pagamento->idformapagamento)) ? 'selected' : '' }}>{{$pagamento->formapagamento}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Quantidade de parcelas --}}
                            <div class="col-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('qtdparcela') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Quantidade de parcelas') }}</label>
                                    <input class="form-control {{ $errors->has('qtdparcela') ? ' is-invalid' : '' }}"
                                    name="qtdparcela" id="input-qtdparcela" type="number" min="1" required="true" aria-required="true"
                                    value="{{ isset($compra) ? $compra->qtdparcela : old('qtdparcela') }}" placeholder="{{ __('N° da Nota fiscal') }}"/>
                                    @if ($errors->has('qtdparcela'))
                                        <span id="qtdparcela-error" class="error text-danger"
                                            for="input-qtdparcela">{{ $errors->first('qtdparcela') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Data Vencimento --}}
                            <div class="col-2">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('datavencimento') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data Vencimento') }}</label>
                                    <input class="form-control {{ $errors->has('datavencimento') ? ' is-invalid' : '' }}"
                                        name="datavencimento" id="input-datavencimento" type="date"
                                        value="{{ isset($compra) ? $compra->datavencimento : old('datavencimento') }}"
                                        placeholder="{{ __('Data emissão') }}" required="true" aria-required="true" />
                                    @if ($errors->has('datavencimento'))
                                        <span id="datavencimento-error" class="error text-danger"
                                            for="input-datavencimento">{{ $errors->first('datavencimento') }}</span>
                                    @endif
                                </div>
                            </div>
                            @if ($agencias->isNotEmpty())
                            {{-- Agência --}}
                            <div class="col-3">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Agência</label>
                                    <select class="form-control" name="idagencia">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach($agencias as $agencia)
                                            <option value="{{ $agencia->idagencia }}" {{ ((isset($compra) && $agencia->idagencia == $compra->idagencia) || (old('idagencia') == $agencia->idagencia)) ? 'selected' : '' }}>{{ "$agencia->nome - $agencia->nagencia" }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            @endif
                            {{-- Observação --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3 {{ $errors->has('observacao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Observação') }}</label>
                                    <input class="form-control{{ $errors->has('observacao') ? ' is-invalid' : '' }}"
                                    name="observacao" id="input-observacao" type="text"
                                    value="{{ isset($compra) ? $compra->observacao : old('observacao') }}" placeholder="{{ __('Observação') }}"/>
                                    @if ($errors->has('observacao'))
                                        <span id="observacao-error" class="error text-danger"
                                            for="input-observacao">{{ $errors->first('observacao') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados da NF</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            {{-- Data emissão --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('dataemissao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data emissão') }}</label>
                                    <input class="form-control {{ $errors->has('dataemissao') ? ' is-invalid' : '' }}"
                                        name="dataemissao" id="input-dataemissao" type="date"
                                        value="{{ isset($compra) ? $compra->dataemissao : old('dataemissao') }}"
                                        placeholder="{{ __('Data emissão') }}" />
                                    @if ($errors->has('dataemissao'))
                                        <span id="dataemissao-error" class="error text-danger"
                                            for="input-dataemissao">{{ $errors->first('dataemissao') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- NFe --}}
                            <div class="col-8">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('nfe') ? ' is-invalid' : '' }}">
                                    <label>{{ __('NFe') }}</label>
                                    <input class="form-control{{ $errors->has('nfe') ? ' is-invalid' : '' }}"
                                        name="nfe" id="input-nfe" type="text"
                                        value="{{ isset($compra) ? $compra->nfe : old('nfe') }}"
                                        placeholder="{{ __('NFe') }}"  />
                                    @if ($errors->has('nfe'))
                                        <span id="nfe-error" class="error text-danger"
                                            for="input-nfe">{{ $errors->first('nfe') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
				<h4 class="mb-3 bg-light">Itens da Compra
                @if(isset($nfItem))
                <a style="float:right" class="importText btn btn-info btn-sm" id="importButton" data-id="{{ isset($compra) ? $compra->idnf : old('idnf') }}">+ importar</a>
                    <a style="float:right" class="insertRecord btn btn-info btn-sm" data-id="{{ isset($compra) ? $compra->idnf : old('idnf') }}" >+ adicionar item</a>
                @endif
                </h4>
            </div>
            <div class="col-md-12 col-lg-12" style="display: none;" id="textareaContainer">
                <div class="row">
                    <div class="col-md-12">

                        <div class="input-group input-group-static my-3 {{ $errors->has('dataemissao') ? ' is-invalid' : '' }}">
                            <label>{{ __('Importar Fatura do Cartão') }}</label>
                            <textarea style="border:1px solid #495057" name="data" class="form-control" rows="12" placeholder="{{ __('Importação de Cartão de Crédito') }}" /></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12 col-lg-12">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class='table table-hover table-striped table-bordered table-sm' id="tab_logic">
                                <thead>
                                    <tr class="info" style="font-size:14px;">
                                        @if (isset($compra) && !$compra->transferkey)
                                            <th class="th-sm">AÇÃO</th>
                                        @endif
                                        <th class="w-50">PRODUTO</th>
                                        <th class="th-sm w-10">CC</th>
                                        <th class="th-sm w-10">DIV</th>
                                        <th class="th-sm">QTD</th>
                                        <th class="th-sm">UN</th>
                                        <th class="th-sm">VALOR UN.</th>
                                        <th class="th-sm">VALOR TOTAL</th>

                                    </tr>
                                </thead>
                                <tbody class="resultbody">
                                    @if(isset($nfItem))
                                        @php
                                            $i = 0;
                                        @endphp
                                        @foreach ($nfItem as $itens)

                                        <tr id="{{ isset($itens) ? $itens->idnfitem : old('idnfitem') }}">
                                            <input class='form-control input-sm'style='width:100%;' type="hidden" name="idnfitem[]" value="{{ isset($itens) ? $itens->idnfitem : old('idnfitem') }}">
                                            <input class='form-control input-sm'style='width:100%;' type="hidden" name="idnf[]" value="{{ isset($itens) ? $itens->idnf : old('idnf') }}">
                                            <input class='form-control input-sm'style='width:100%;' type="hidden" name="importado[]" value="{{ isset($itens) ? $itens->importado : old('importado') }}">
                                            @if (isset($compra) && !$compra->transferkey)
                                                <td class="custom-tbl" style="text-align: center;">
                                                    <a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="{{ $itens->idnfitem }}" style="cursor: pointer;" >delete</a>
                                                </td>
                                            @endif
                                            <td class="custom-tbl">
                                                @if (!empty($itens->item))
                                                    <input class="form-control input-sm" style="width: 100%;" type="text" name="item[]" value="{{ isset($itens) ? $itens->item : old('item') }}">
                                                @else
                                                <select class="form-control input-sm" {{ $compra->transferkey ? 'disabled' : '' }} name="idprodserv[]" onchange="getSelectedValue(this)">

                                                    <option value="">- Selecionar -</option>
                                                    @foreach($prodserv as $prod)
                                                        <option value="{{ $prod->idprodserv }}"
                                                                data-unidade="{{ $prod->unidade }}"
                                                                data-valorcompra="{{ $prod->valorcompra }}"
                                                                {{ ((isset($itens) && $prod->idprodserv == $itens->idprodserv) || (old('idprodserv') == $prod->idprodserv)) ? 'selected' : '' }}>{{ htmlspecialchars($prod->prodserv) }}</option>
                                                    @endforeach
                                                @endif
                                                </select>
                                            </td>
                                            <td class="custom-tbl">
                                                <select class="form-control input-sm" {{ $compra->transferkey ? 'disabled' : '' }} name="idgrupoitem[]">
                                                    <option value="">- Selecionar -</option>
                                                    @foreach($grupoItens as $grupoitem)
                                                        <option value="{{ $grupoitem->idgrupoitem }}"

                                                                {{ ((isset($itens) && $grupoitem->idgrupoitem == $itens->idgrupoitem) || (old('idgrupoitem') == $grupoitem->idgrupoitem)) ? 'selected' : '' }}>{{$grupoitem->grupoitem}}</option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td class="custom-tbl">
                                                <select class="form-control input-sm" {{ $compra->transferkey ? 'disabled' : '' }} name="iditem[]">
                                                    <option value="">- Selecionar -</option>
                                                    @foreach($listaItens as $listaItem)
                                                        <option value="{{ $listaItem->iditem }}"
                                                        data-idgrupoitem="{{ $listaItem->idgrupoitem }}" data-item="{{ $listaItem->item }}" value="{{ $listaItem->iditem }}"
                                                                {{ ((isset($itens) && $listaItem->iditem == $itens->iditem) || (old('iditem') == $listaItem->iditem)) ? 'selected' : '' }}>{{$listaItem->item}}</option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td class="custom-tbl">
                                                <input {{ $compra->transferkey ? 'disabled' : '' }} style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="text" name="qtd[]"  value="{{ isset($itens) ? number_format($itens->qtd, 2, ',','') : old('qtd') }}" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >
                                            </td>
                                            <td class="custom-tbl">
                                                <input {{ $compra->transferkey ? 'disabled' : '' }} class='form-control input-sm'style='width:100%;' type="text" name="un[]" value="{{ isset($itens) ? $itens->un : old('un') }}">
                                            </td>
                                            <td class="custom-tbl">
                                                <input {{ $compra->transferkey ? 'disabled' : '' }} style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="text" name="valorun[]" value="{{ isset($itens) ? number_format($itens->valorun, 2, ',','') : old('valorun') }}" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)">
                                            </td>
                                            <td class="custom-tbl">
                                                <input {{ $compra->transferkey ? 'disabled' : '' }} style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="text" name="valoritem[]" value="{{ isset($itens) ? number_format($itens->valoritem, 2, ',','') : old('valoritem') }}" readonly>
                                            </td>

                                        </tr>
                                        @php
                                            $i++;
                                        @endphp
                                        @endforeach
                                    @endif
                                </thead>

                                <tfoot>
                                    <tr class='info'>
                                        <td style='width:65%;text-align:right;padding:4px;font-size:14px;' colspan='7'>VALOR DOS ITENS:</td>
                                        <td style='padding:0px;font-size:14px;'>
                                            <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('valornf') ? ' is-invalid' : '' }}"
                                                name="valornf" id="input-valornf" type="number" step="0.01"
                                                value="{{ isset($compra) ? $compra->valornf : old('valornf') }}" placeholder="{{ __('Valor da NF') }}" readonly/>
                                                @if ($errors->has('valornf'))
                                                    <span id="valornf-error" class="error text-danger"
                                                        for="input-valornf">{{ $errors->first('valornf') }}</span>
                                                @endif

                                        </td>
                                    </tr>
                                    <tr class='info'>
                                        <td style='width:65%;text-align:right;padding:4px;font-size:14px;' colspan='7'>VALOR DO DESCONTO (-):</td>
                                        <td style='padding:0px;font-size:14px;'>

                                        <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('descontonf') ? ' is-invalid' : '' }}"
                                                name="descontonf" id="input-descontonf" type="text" step="0.01" placeholder="{{ __('Valor da NF') }}"
                                                value="{{ isset($compra) ? number_format($compra->descontonf, 2, ',','') : old('descontonf') }}" onblur="updateValorNf()" oninput="formatarEntradaNumerica(this);updateValorNf()"/>
                                                @if ($errors->has('descontonf'))
                                                    <span id="descontonf-error" class="error text-danger"
                                                        for="input-descontonf">{{ $errors->first('descontonf') }}</span>
                                                @endif

                                        </td>
                                    </tr>
                                    <tr class='info'>
                                        <td style='width:65%;text-align:right;padding:4px;font-size:14px;' colspan='7'>VALOR TOTAL:</td>
                                        <td style='padding:0px;font-size:14px;'>

                                        <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('totalnf') ? ' is-invalid' : '' }}"
                                                name="totalnf" id="input-totalnf" type="number" step="0.01"
                                                value="{{ isset($compra) ? $compra->totalnf : old('totalnf') }}" placeholder="{{ __('Valor Total da NF') }}" readonly/>
                                                @if ($errors->has('totalnf'))
                                                    <span id="totalnf-error" class="error text-danger"
                                                        for="input-totalnf">{{ $errors->first('totalnf') }}</span>
                                                @endif

                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@if(isset($nfParcela))
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
				<h4 class="mb-3 bg-light">Parcela(s)
                </h4>
            </div>
            <div class="col-md-12 col-lg-12">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class='table table-hover table-striped table-bordered table-sm' id="tab_logic">
                            <thead>
                                <tr>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        ID
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        NF
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Parcela
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Total
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Status
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        VENCIMENTO
                                    </th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($nfParcela as $parcela)
                                    <tr>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <p class="mb-0 text-sm">
                                                        <a href="{{ route('admin.nfparcelasdebito.edit', $parcela->idnfparcela) }}">{{$parcela->idnfparcela }} <i class="fas fa-link"></i> </a></p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <p class="mb-0 text-sm">{{ $parcela->nf->idnf }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <p class="mb-0 text-sm">{{ $parcela->parcela }} /
                                                        {{ $parcela->nf->qtdparcela }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <p class="mb-0 text-sm">R$
                                                        {{ number_format($parcela->valor, 2, ',', '.') }}
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <p class="mb-0 text-sm">{{ $parcela->status }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">
                                                    {{  date('d/m/Y', strtotime($parcela->datavencimento)) }}</h6>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $compra ?? null])
    </div>
    @if(isset($compra))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $compra])
    </div>
    @endif

</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($compra) ? 'Atualizar' : 'Adicionar').' Compra') }}</button>
        <a href="{{ route('admin.compras.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
        @if(isset($compra))
        <a class="btn bg-gradient-dark" href="{{route('admin.compras.create')}}"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Compra</a>
        @endif
    </div>
</div>

@push('js')
    {{-- Select2 --}}
    <script src="{{ asset('assets/js/plugins/select2.min.js') }}"></script>
    <script>
        $('.select2').select2();

            $(document).on("click", ".deleteRecord", function(){
                var id = $(this).data("id");
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "../../nfitem/"+id,
                    type: 'DELETE',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (){
                        console.log("it Works");
                        var row = $('#'+id).remove();
                        //row.style.display = 'none';
                        updateValorNf();
                    }
                });
            });



            function montaHtml(idnfitem, idnf){
                var trHTML = '<tr id="'+idnfitem+'">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idnfitem[]" value="'+idnfitem+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idnf[]" value="'+idnf+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="importado[]" value="0" onfocus="focused(this)" onfocusout="defocused(this)">' +

                                '<td class="custom-tbl" style="text-align: center;">' +
                                    '<a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="'+idnfitem+'" style="cursor: pointer;">delete</a>' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<select class="form-control input-sm" name="idprodserv[]" onchange="getSelectedValue(this)">' +
                                        '<option value="">- Selecionar -</option><?=$opt;?>'+
                                    '</select>' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<select class="form-control input-sm" name="idgrupoitem[]">' +
                                        '<option value="">- Selecionar -</option><?=$grit;?>'+
                                    '</select>' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<select class="form-control input-sm" name="iditem[]">' +
                                        '<option value="">- Selecionar -</option><?=$it;?>'+
                                    '</select>' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="text" name="qtd[]" step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="text" name="un[]" value="" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="text" name="valorun[]" step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="text" name="valoritem[]"  step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                '</td>' +
                            '</tr>';
                return trHTML;
            }

            $(".insertRecord").click(function(){



                var id = $(this).data("id");
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "../../nfitemadd/"+id,
                    type: 'POST',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (response){
                        console.log("it Works");
                        var idNfItem = response.success;
                        var tr = montaHtml(idNfItem,id);
                        $('#tab_logic').append(tr);

                    }
                    });
                });

    </script>
    <script>
    function getSelectedValue(select) {
        var selectedOption = select.options[select.selectedIndex];
        var prodData = selectedOption.dataset;
        var row = select.closest('tr');
        // Preencha os outros campos com os dados obtidos
        row.querySelector("input[name='un[]']").value = prodData.unidade;
        row.querySelector("input[name='valorun[]']").value = prodData.valorcompra;
        row.querySelector("input[name='qtd[]']").focus();
        row.querySelector("input[name='qtd[]']").blur();
        updateValorNf();

    }


    function updateValorItem(element) {
       // debugger;
        var row = element.closest('tr'); // Encontra o elemento pai <tr>
        var qtd = converterParaNumero(row.querySelector("input[name='qtd[]']").value);
        var valorUn = converterParaNumero(row.querySelector("input[name='valorun[]']").value);
        if (!isNaN(parseFloat(valorUn)) && valorUn !== "" && valorUn !== undefined) {
        // O valor é válido e não é NaN
            valorUn = (valorUn);
            console.log('AQUI');
        } else {
        // O valor é inválido ou NaN
            valorUn.value = 0;
            console.log('ALI');
        }

        if (!isNaN(parseFloat(qtd)) && qtd.value !== "" && qtd !== undefined) {
        // O valor é válido e não é NaN
            qtd = (qtd);
            console.log('AQUI2');
        } else {
        // O valor é inválido ou NaN
            qtd = 0;
            console.log('ALI2');
        }
        var valorItem = qtd * valorUn;
       // debugger;
        var valorItemInput = row.querySelector("input[name='valoritem[]']");
        console.log("valorItem:", valorItem);
        console.log("valorItem:", valorItem.toFixed(2));
        console.log("valorItem:", valorItem.toFixed(2).replace('.', ','));
        console.log("valorItemInput:", valorItemInput.value);
        valorItemInput.value = valorItem.toFixed(2).replace('.', ',');
        console.log("valorItemInput:", valorItemInput.value);
        updateValorNf();
    }


    function updateValorNf() {
        //debugger;
        var valorItemInputs = document.querySelectorAll("input[name='valoritem[]']");
        var valornf = 0;

        // Itera sobre os campos e soma os valores
        for (var i = 0; i < valorItemInputs.length; i++) {
            var valorItem = parseFloat(valorItemInputs[i].value.replace(',', '.'));
            if (!isNaN(valorItem)) {
                valornf += valorItem;
            //    console.log('valorItem: '+valorItem);
            //    console.log('valornf: '+valornf);
            //    console.log('--------------');
            }
        }

        // Atualiza o campo de valor total
        var valornfInput = document.querySelector("input[name='valornf']");
        if (valornfInput) {
            valornfInput.value = valornf.toFixed(2);
        }

        //Busca o valor do campo Desconto
        var descontonfInput = document.querySelector("input[name='descontonf']");

        // Atualiza o campo de valor total
        var totalnfInput = document.querySelector("input[name='totalnf']");

        var valornf = parseFloat(valornfInput.value.replace(',', '.')); // Supondo que valornfInput é o valor original
        var desconto = parseFloat(descontonfInput.value.replace(',', '.')); // Converte o valor do desconto para um número
       // console.log('desconto: '+desconto);
        if (desconto) {
            var total = valornf - desconto; // Calcula o total
        }else{
            var total = valornf;
        }
       // console.log('total: '+total);
        totalnfInput.value = total.toFixed(2); // Formata o número com dois dígitos decimais e define o valor do input

    }
</script>
<script>
    $(document).ready(function() {
        $('#importButton').click(function() {
            $('#textareaContainer').show();
        });
    });

    function formatarEntradaNumerica(el) {
        // Primeiro, substitui todos os pontos por vírgulas
        let valor = el.value.replace(/\./g, ',');

        // Remove caracteres que não são dígitos ou vírgula
        valor = valor.replace(/[^0-9,]/g, '');

        // Permite apenas uma vírgula
        let partes = valor.split(',');
        if (partes.length > 2) {
            valor = partes[0] + ',' + partes.slice(1).join('');
        }

        el.value = valor;
    }

    function converterParaNumero(valor) {
        // Verifica se o valor é não nulo e não vazio
        if (valor) {
            // Converte vírgulas em pontos
            var valorConvertido = valor.replace(',', '.');

            // Converte para float e verifica se é NaN. Se for NaN, retorna 0
            var numero = parseFloat(valorConvertido);
            return isNaN(numero) ? 0 : numero;
        }
        return 0;
    }


</script>
<script>
$(document).ready(function() {
    // Delegar evento de mudança para selects que são adicionados dinamicamente
    $(document).on('change', 'select[name="idgrupoitem[]"]', function() {
        var selectedGrupoItemId = $(this).val(); // Obter o ID do grupoitem selecionado

        // Filtro para o segundo select box
        var relatedSelect = $(this).closest('.custom-tbl').next('.custom-tbl').find('select[name="iditem[]"]');
        relatedSelect.find('option').each(function() {
            if ($(this).data('idgrupoitem') == selectedGrupoItemId || selectedGrupoItemId === "") {
                $(this).show(); // Mostrar opção
            } else {
                $(this).hide(); // Esconder opção
            }
        });

        // Verificar o valor do campo de entrada oculto
        var importadoValue = $(this).closest('tr').find('input[name="importado[]"]').val();

        // Resetar o segundo select box para seu estado padrão, se importado não for 1
        if (importadoValue != '1') {
            relatedSelect.val('');
        }
    });
});

</script>
    @include('partials.upload-js')
@endpush
