<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Gerenciamento de Empresas</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($empresa))
            <div class="col-md-9 col-lg-9"> 
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$empresa->idempresa;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$empresa->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>

<div class="row">

    <div class="col-md-6">
            
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                        {{-- Sigla  --}}
                            <div class="col-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('sigla') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Apelido') }}</label>
                                    <input class="form-control{{ $errors->has('sigla') ? ' is-invalid' : '' }}"
                                    name="sigla" id="input-sigla" type="text"
                                    value="{{ isset($empresa) ? $empresa->sigla : old('sigla') }}" placeholder="{{ __('Sigla') }}"/>
                                    @if ($errors->has('sigla'))
                                        <span id="razaosocial-error" class="error text-danger"
                                            for="input-sigla">{{ $errors->first('sigla') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">   
                            {{-- Razão social --}}
                            <div class="col-8">
                                <div class="input-group input-group-static my-3 {{ $errors->has('razaosocial') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Razão social') }}</label>
                                    <input class="form-control{{ $errors->has('razaosocial') ? ' is-invalid' : '' }}"
                                    name="razaosocial" id="input-razaosocial" type="text"
                                    value="{{ isset($empresa) ? $empresa->razaosocial : old('razaosocial') }}" placeholder="{{ __('Razão social') }}"/>
                                    @if ($errors->has('razaosocial'))
                                        <span id="razaosocial-error" class="error text-danger"
                                            for="input-razaosocial">{{ $errors->first('razaosocial') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- CNPJ --}}
                            <div class="col-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('cnpj') ? ' is-invalid' : '' }}">
                                    <label>{{ __('CNPJ') }}</label>
                                    <input class="form-control cnpj {{ $errors->has('cnpj') ? ' is-invalid' : '' }}"
                                    name="cnpj" id="input-cnpj" type="text"
                                    value="{{ isset($empresa) ? $empresa->cnpj : old('cnpj') }}" placeholder="{{ __('CNPJ') }}"/>
                                    @if ($errors->has('cnpj'))
                                        <span id="cnpj-error" class="error text-danger"
                                            for="input-cnpj">{{ $errors->first('cnpj') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Nome Fantasia  --}}
                            <div class="col-8">
                                <div class="input-group input-group-static my-3 {{ $errors->has('nomefantasia') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Nome Fantasia') }}</label>
                                    <input class="form-control{{ $errors->has('razaosocial') ? ' is-invalid' : '' }}"
                                    name="nomefantasia" id="input-nomefantasia" type="text"
                                    value="{{ isset($empresa) ? $empresa->nomefantasia : old('nomefantasia') }}" placeholder="{{ __('Nome Fantasia') }}"/>
                                    @if ($errors->has('nomefantasia'))
                                        <span id="razaosocial-error" class="error text-danger"
                                            for="input-nomefantasia">{{ $errors->first('nomefantasia') }}</span>
                                    @endif
                                </div>
                            </div>
                           
                            {{-- Inscrição estadual --}}
                            <div class="col-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('inscestadual') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Inscrição estadual') }}</label>
                                    <input class="form-control{{ $errors->has('inscestadual') ? ' is-invalid' : '' }}"
                                    name="inscestadual" id="input-inscestadual" type="text"
                                    value="{{ isset($empresa) ? $empresa->inscestadual : old('inscestadual') }}" placeholder="{{ __('Inscrição estadual') }}"/>
                                    @if ($errors->has('inscestadual'))
                                        <span id="inscestadual-error" class="error text-danger"
                                            for="input-inscestadual">{{ $errors->first('inscestadual') }}</span>
                                    @endif
                                </div>
                            </div>   
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
    <div class="card mb-4">
        <div class="card-body ">
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <h4 class="mb-3 bg-light">Endereço</h4>
                </div>
                <div class="col-md-12 col-lg-12">
                    <div class="row">
                        {{-- Cep --}}
                        <div class="row">
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('cep') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Cep') }}</label>
                                    <input class="form-control cep {{ $errors->has('cep') ? ' is-invalid' : '' }}"
                                        name="cep" id="input-cep" type="text"
                                        value="{{ isset($empresa) ? $empresa->cep : old('cep') }}"
                                        placeholder="{{ __('Cep') }}" required="true" aria-required="true" />
                                    @if ($errors->has('cep'))
                                        <span id="cep-error" class="error text-danger"
                                            for="input-cep">{{ $errors->first('cep') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>        
                        {{-- Endereço --}}
                        <div class="col-5">
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('endereco') ? ' is-invalid' : '' }}">
                                <label>{{ __('Endereço') }}</label>
                                <input class="form-control{{ $errors->has('endereco') ? ' is-invalid' : '' }}"
                                    name="endereco" id="input-endereco" type="text"
                                    value="{{ isset($empresa) ? $empresa->endereco : old('endereco') }}"
                                    placeholder="{{ __('Endereço') }}" required="true" aria-required="true" />
                                @if ($errors->has('endereco'))
                                    <span id="endereco-error" class="error text-danger"
                                        for="input-endereco">{{ $errors->first('endereco') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Número --}}
                        <div class="col-2">
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('numero') ? ' is-invalid' : '' }}">
                                <label>{{ __('Número') }}</label>
                                <input class="form-control{{ $errors->has('numero') ? ' is-invalid' : '' }}"
                                    name="numero" id="input-numero" type="text"
                                    value="{{ isset($empresa) ? $empresa->numero : old('numero') }}"
                                    placeholder="{{ __('Número') }}" required="true" aria-required="true" />
                                @if ($errors->has('numero'))
                                    <span id="numero-error" class="error text-danger"
                                        for="input-numero">{{ $errors->first('numero') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Complemento --}}
                        <div class="col-5">
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('complemento') ? ' is-invalid' : '' }}">
                                <label>{{ __('Complemento') }}</label>
                                <input class="form-control{{ $errors->has('complemento') ? ' is-invalid' : '' }}"
                                    name="complemento" id="input-complemento" type="text"
                                    value="{{ isset($empresa) ? $empresa->complemento : old('complemento') }}"
                                    placeholder="{{ __('Complemento') }}" />
                                @if ($errors->has('complemento'))
                                    <span id="complemento-error" class="error text-danger"
                                        for="input-complemento">{{ $errors->first('complemento') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Bairro --}}
                        <div class="col-5">
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('bairro') ? ' is-invalid' : '' }}">
                                <label>{{ __('Bairro') }}</label>
                                <input class="form-control{{ $errors->has('bairro') ? ' is-invalid' : '' }}"
                                    name="bairro" id="input-bairro" type="text"
                                    value="{{ isset($empresa) ? $empresa->bairro : old('bairro') }}"
                                    placeholder="{{ __('Bairro') }}" required="true" aria-required="true" />
                                @if ($errors->has('bairro'))
                                    <span id="bairro-error" class="error text-danger"
                                        for="input-bairro">{{ $errors->first('bairro') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Cidade --}}
                        <div class="col-5">
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('cidade') ? ' is-invalid' : '' }}">
                                <label>{{ __('Cidade') }}</label>
                                <input class="form-control{{ $errors->has('cidade') ? ' is-invalid' : '' }}"
                                    name="cidade" id="input-cidade" type="text"
                                    value="{{ isset($empresa) ? $empresa->cidade : old('cidade') }}"
                                    placeholder="{{ __('Cidade') }}" required="true" aria-required="true" />
                                @if ($errors->has('cidade'))
                                    <span id="cidade-error" class="error text-danger"
                                        for="input-cidade">{{ $errors->first('cidade') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Estado --}}
                        <div class="col-2">
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('estado') ? ' is-invalid' : '' }}">
                                <label>{{ __('Estado') }}</label>
                                <input class="form-control{{ $errors->has('estado') ? ' is-invalid' : '' }}"
                                    name="estado" id="input-estado" type="text"
                                    value="{{ isset($empresa) ? $empresa->estado : old('estado') }}"
                                    placeholder="{{ __('Estado') }}" required="true" aria-required="true" />
                                @if ($errors->has('estado'))
                                    <span id="estado-error" class="error text-danger"
                                        for="input-estado">{{ $errors->first('estado') }}</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $empresa ?? null])
    </div>
    @if(isset($empresa))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $empresa])
    </div>
    @endif

</div>
<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($empresa) ? 'Atualizar' : 'Adicionar').' Empresa') }}</button>
        <a href="{{ route('admin.empresas.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
        @if(isset($empresa))
        <a class="btn bg-gradient-dark" href="{{route('admin.empresas.create')}}"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Venda</a>
        @endif
    </div>
</div>

@push('js')
    @include('partials.upload-js')
@endpush