<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Evento</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($evento))
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$evento->idevento;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$evento->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados do Cliente</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            {{-- Empresa --}}
                            <div class="col-md-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Empresa</label>
                                    <select class="form-control" name="idempresa">
                                    <option value="" disabled="disabled">- Selecionar -</option>
                                    @foreach($empresas as $empresa)
                                        <option value="{{ $empresa->idempresa }}" {{ ((isset($evento) && $empresa->idempresa == $evento->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Cliente --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Cliente</label>
                                    <select class="form-control" name="idcliente">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach($clientes as $cliente)
                                            <option value="{{ $cliente->idpessoa }}" {{ ((isset($evento) && $cliente->idpessoa == $evento->idcliente) || (old('idpessoa') == $cliente->idpessoa)) ? 'selected' : '' }}>{{ $cliente->razaosocial ?? $cliente->nome }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Tipo de Evento</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                        {{-- Tipo de Evento --}}
                            <div class="col-md-12">
                                <div class="input-group input-group-static my-3">
                                    <label id="label-ideventotipo" class="ms-0">Tipo</label>
                                    <select class="form-control" name="ideventotipo" id="select-ideventotipo" onchange="ApresentaDados(this)" required="true" aria-required="true">
                                        <option value="">Selecionar</option>
                                        @foreach($eventoTipos as $eventoTipo)
                                            <option value="{{ $eventoTipo->ideventotipo }}" data-veiculo="{{ $eventoTipo->veiculo }}"
                                                    data-pessoa="{{ $eventoTipo->pessoa }}" data-qtd="{{ $eventoTipo->qtd }}"
                                                    data-hora="{{ $eventoTipo->hora }}" data-venda="{{ $eventoTipo->venda }}"
                                                    data-datapadrao="{{ $eventoTipo->datapadrao }}" data-horapadrao="{{ $eventoTipo->horapadrao }}"
                                                    data-valorvenda="{{ $eventoTipo->prodserv->valorvenda ?? '' }}"
                                                    data-prodserv="{{ $eventoTipo->prodserv->prodserv ?? '' }}" data-idprodserv="{{ $eventoTipo->idprodserv }}"

                                                    {{ ((isset($evento) && $eventoTipo->ideventotipo == $evento->eventotipo->ideventotipo) || (old('ideventotipo') == $eventoTipo->ideventotipo)) ? 'selected' : '' }}>{{$eventoTipo->eventotipo}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Pessoa --}}
                            <div class="col-12 d-none" id="div-idpessoa">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Colaborador</label>
                                    <select class="form-control" name="idpessoa" id="input-idpessoa">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach($pessoas as $pessoa)
                                            <option value="{{ $pessoa->idpessoa }}" {{ ((isset($evento) && $pessoa->idpessoa == $evento->idpessoa) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{$pessoa->nome}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Veiculo --}}
                            <div class="col-12 d-none" id="div-idveiculo">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Veículo</label>
                                    <select class="form-control" name="idveiculo" id="input-idveiculo">
                                        <option value="" >- Selecionar -</option>
                                        @foreach($veiculos as $veiculo)
                                        <option value="{{ $veiculo->idveiculo }}" {{ ((isset($evento) && $veiculo->idveiculo == $evento->idveiculo) || (old('idveiculo') == $veiculo->idveiculo)) ? 'selected' : '' }}>{{$veiculo->placa}} - {{$veiculo->marca}} - {{$veiculo->modelo}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Agendamento</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="input-group input-group-static my-3 {{ $errors->has('evento') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Titulo') }}</label>
                                    <input class="form-control{{ $errors->has('evento') ? ' is-invalid' : '' }}"
                                    name="evento" id="input-evento" type="text"
                                    value="{{ isset($evento) ? $evento->evento : old('evento') }}" placeholder="{{ __('Nome do Evento') }}"/>
                                    @if ($errors->has('evento'))
                                        <span id="evento-error" class="error text-danger"
                                            for="input-evento">{{ $errors->first('evento') }}</span>
                                    @endif
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="row">
                        {{-- Data --}}
                        <div class="col-3">
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('data') ? ' is-invalid' : '' }}">
                                <label>{{ __('Data') }}</label>
                                <input class="form-control {{ $errors->has('data') ? ' is-invalid' : '' }}"
                                    name="data" id="input-data" type="date"
                                    value="{{ isset($evento) ? $evento->data : old('data') }}"
                                    placeholder="{{ __('Data') }}" required="true" aria-required="true" />
                                @if ($errors->has('data'))
                                    <span id="data-error" class="error text-danger"
                                        for="input-data">{{ $errors->first('data') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Hora --}}
                        <div class="col-3" id="div-hora">
                            <div class="input-group input-group-static my-3 {{ $errors->has('hora') ? ' is-invalid' : '' }}">
                                <label>{{ __('Hora') }}</label>
                                <input type="time" name="hora" id="input-hora" class="form-control form-control-sm time-input" value="{{ isset($evento) ? $evento->hora : old('hora') }}" step="60">
                                {{-- <select class="form-control {{ $errors->has('hora') ? ' is-invalid' : '' }}" name="hora" id="input-hora">
                                    @foreach (range(0, 23) as $hora)
                                        @foreach (['00', '15', '30', '45'] as $minuto)
                                            <option value="{{ sprintf('%02d', $hora) }}:{{ $minuto }}:00"
                                                {{ (isset($evento) && $evento->hora === sprintf('%02d', $hora) . ':' . $minuto . ':00') ? 'selected' : '' }}>
                                                {{ sprintf('%02d', $hora) }}:{{ $minuto }}
                                            </option>
                                        @endforeach
                                    @endforeach
                                </select>
                                @if ($errors->has('hora'))
                                    <span id="hora-error" class="error text-danger" for="input-hora">{{ $errors->first('hora') }}</span>
                                @endif --}}
                            </div>
                        </div>


                        {{-- Datafim --}}
                        <div class="col-3" >
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('datafim') ? ' is-invalid' : '' }}">
                                <label>{{ __('Data Fim') }}</label>
                                <input class="form-control {{ $errors->has('datafim') ? ' is-invalid' : '' }}"
                                    name="datafim" id="input-datafim" type="date"
                                    value="{{ isset($evento) ? $evento->datafim : old('datafim') }}"
                                    placeholder="{{ __('Data') }}" required="true" aria-required="true" />
                                @if ($errors->has('datafim'))
                                    <span id="datafim-error" class="error text-danger"
                                        for="input-datafim">{{ $errors->first('datafim') }}</span>
                                @endif
                            </div>
                        </div>
                        {{-- Horafim --}}
                        <div class="col-3" id="div-horafim">
                            <div class="input-group input-group-static my-3 {{ $errors->has('horafim') ? ' is-invalid' : '' }}">
                                <label>{{ __('Hora Fim') }}</label>
                                <input type="time" name="horafim" id="input-horafim" class="form-control form-control-sm time-input" value="{{ isset($evento) ? $evento->horafim : old('horafim') }}" step="60">
                                {{-- <select class="form-control {{ $errors->has('horafim') ? ' is-invalid' : '' }}" name="horafim" id="input-horafim">
                                    @foreach (range(0, 23) as $hora)
                                        @foreach (['00', '15', '30', '45'] as $minuto)
                                            <option value="{{ sprintf('%02d', $hora) }}:{{ $minuto }}:00"
                                                {{ (isset($evento) && $evento->horafim === sprintf('%02d', $hora) . ':' . $minuto . ':00') ? 'selected' : '' }}>
                                                {{ sprintf('%02d', $hora) }}:{{ $minuto }}
                                            </option>
                                        @endforeach
                                    @endforeach
                                </select>
                                @if ($errors->has('horafim'))
                                    <span id="horafim-error" class="error text-danger" for="input-horafim">{{ $errors->first('horafim') }}</span>
                                @endif --}}
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6" id="div-venda">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Item da Venda</h4>
                    </div>
                    <div class="{{ isset($nf) ? ' col-md-8' : 'col-md-12' }}">
                        <div class="row">
                        {{-- Item --}}
                            <div class="col-12 ">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Item</label>
                                    <input class="form-control{{ $errors->has('item') ? ' is-invalid' : '' }}"
                                    name="item" id="input-item" type="text"
                                    value="{{ isset($evento) ? $evento->item : old('item') }}" placeholder="{{ __('Descricao') }}" readonly/>
                                    @if ($errors->has('evento'))
                                        <span id="item-error" class="error text-danger"
                                            for="input-item">{{ $errors->first('item') }}</span>
                                    @endif

                                    <input
                                    name="idprodserv" id="input-idprodserv" type="hidden"
                                    value="{{ isset($evento) ? $evento->idprodserv : old('idprodserv') }}"/>
                                    <input
                                    name="valorvenda" id="input-valorvenda" type="hidden"
                                    value="{{ isset($evento) ? $evento->valorvenda : old('valorvenda') }}"/>
                                </div>
                            </div>
                            {{-- Qtd --}}
                            <div class="col-4  d-none" id="div-qtd">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Quantidade </label>
                                    <input class="form-control{{ $errors->has('qtd') ? ' is-invalid' : '' }}"
                                    name="qtd" id="input-qtd" type="text"  onblur="updateValorItem()" oninput="formatarEntradaNumerica(this);updateValorItem()"
                                    value="{{ isset($evento) ? $evento->qtd : 1 }}" placeholder="{{ __('Quantidade') }}"/>
                                    @if ($errors->has('evento'))
                                        <span id="qtd-error" class="error text-danger"
                                            for="input-qtd">{{ $errors->first('qtd') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-4 ">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Valor Un.</label>
                                    <input class="form-control{{ $errors->has('valorun') ? ' is-invalid' : '' }}"
                                    name="valorun" id="input-valorun" type="text"
                                    value="{{ isset($evento) ? number_format($evento->valorun, 2, ',','') : old('valorun') }}" onblur="updateValorItem()" oninput="formatarEntradaNumerica(this);updateValorItem()"
                                     placeholder="{{ __('Descricao') }}" />
                                    @if ($errors->has('evento'))
                                        <span id="valorun-error" class="error text-danger"
                                            for="input-valorun">{{ $errors->first('valorun') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-4 ">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Valor Total</label>
                                    <input class="form-control {{ $errors->has('valoritem') ? ' is-invalid' : '' }}"
                                    name="valoritem" id="input-valoritem" type="text"
                                    value="{{ isset($evento) ? number_format($evento->valoritem, 2, ',',''): old('valoritem') }}" placeholder="{{ __('Descricao') }}" readonly/>
                                    @if ($errors->has('evento'))
                                        <span id="valoritem-error" class="error text-danger"
                                            for="input-valoritem">{{ $errors->first('valoritem') }}</span>
                                    @endif
                                </div>
                            </div>


                        </div>
                    </div>
                    @if(isset($nf))
                    <div class="col-md-4 col-lg-4" style=" border-left: 1px solid #d2d2d2; height: auto; padding-right: 20px;">
                        <div class="row">

                            {{-- Qtd --}}

                            <div class="col-12 ">
                                <div class=" my-3">
                                    <label class="ms-0">ID</label>
                                    <div class="row">
                                        <div class="col-md-9 col-lg-9">
                                            <a target="_blank" href="/admin/vendas/{{$nf->idnf}}/edit">
                                                <span class="badge badge-sm bg-light text-dark"># {{$nf->idnf}} <i class="fas fa-link"></i></span>
                                            </a>
                                        </div>
                                        <div class="col-md-3 col-lg-3">
                                            <a target="_blank" href="/admin/vendas/{{$nf->idnf}}/edit">
                                                <span class="float-end badge badge-sm {{$bg_status_nf}}">{{$nf->status}} </span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 ">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0 col-12">Vencimento</label>
                                    <input class="form-control{{ $errors->has('valorun') ? ' is-invalid' : '' }}"
                                    name="valorun" id="input-valorun" type="text"
                                    value="{{ isset($nf) ? $nf->datavencimento->format('d/m/Y') : old('datavencimento') }}"
                                     placeholder="{{ __('Descricao') }}" disabled readonly/>
                                    @if ($errors->has('evento'))
                                        <span id="valorun-error" class="error text-danger"
                                            for="input-valorun">{{ $errors->first('valorun') }}</span>
                                    @endif
                                </div>
                            </div>


                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>



    <div class="col-md-8 d-none">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Participantes</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                        {{-- Pessoa --}}
                            <div class="col-8">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Cliente/Colaborador</label>
                                    <select class="form-control" name="idpessoa">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach($pessoas as $pessoa)
                                            <option value="{{ $pessoa->idpessoa }}" {{ ((isset($evento) && $pessoa->idpessoa == $evento->idpessoa) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{$pessoa->nome}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class='table table-hover table-striped table-bordered table-sm' id="tab_logic">
                                        <thead>
                                            <tr class="info" style="font-size:14px;">
                                                <th class="th-sm">AÇÃO</th>
                                                <th class="w-75">PESSOA</th>
                                                <th class="th-sm">TIPO</th>
                                                <th class="th-sm">STATUS</th>
                                                <th class="th-sm">CRIADOEM</th>
                                                <th class="th-sm">ALTERADOEM</th>

                                            </tr>
                                        </thead>
                                        <tbody class="resultbody">
                                            @if(isset($eventoPessoas))
                                                @foreach ($eventoPessoas as $eventopessoa)
                                                <tr id="{{ isset($eventopessoa) ? $eventopessoa->ideventopessoa : old('ideventopessoa') }}">
                                                    <td class="custom-tbl">
                                                        {{ $eventopessoa->pessoa->nome }}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ $eventopessoa->pessoa->tipo }}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ $eventopessoa->status }}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ $eventopessoa->criadoem }}
                                                    </td>
                                                    <td class="custom-tbl">
                                                        {{ $eventopessoa->alteradoem }}
                                                    </td>

                                                </tr>
                                                @endforeach
                                            @endif
                                        </tbody>

                                        <tfoot>
                                            <tr class='info'>
                                                <td style='width:65%;text-align:right;padding:4px;font-size:14px;' colspan='5'>VALOR DOS ITENS:</td>
                                                <td style='padding:0px;font-size:14px;'>
                                                    <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('valornf') ? ' is-invalid' : '' }}"
                                                        name="valornf" id="input-valornf" type="number" step="0.01"
                                                        value="{{ isset($pedido) ? $pedido->valornf : old('valornf') }}" placeholder="{{ __('Valor da NF') }}" readonly/>
                                                        @if ($errors->has('valornf'))
                                                            <span id="valornf-error" class="error text-danger"
                                                                for="input-valornf">{{ $errors->first('valornf') }}</span>
                                                        @endif

                                                </td>
                                            </tr>
                                            <tr class='info'>
                                                <td style='width:65%;text-align:right;padding:4px;font-size:14px;' colspan='5'>VALOR DO DESCONTO (-):</td>
                                                <td style='padding:0px;font-size:14px;'>

                                                <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('descontonf') ? ' is-invalid' : '' }}"
                                                        name="descontonf" id="input-descontonf" type="number" step="0.01"
                                                        value="{{ isset($pedido) ? $pedido->descontonf : old('descontonf') }}" placeholder="{{ __('Valor do Desconto') }}"/>
                                                        @if ($errors->has('descontonf'))
                                                            <span id="descontonf-error" class="error text-danger"
                                                                for="input-descontonf">{{ $errors->first('descontonf') }}</span>
                                                        @endif

                                                </td>
                                            </tr>
                                            <tr class='info'>
                                                <td style='width:65%;text-align:right;padding:4px;font-size:14px;' colspan='5'>VALOR TOTAL:</td>
                                                <td style='padding:0px;font-size:14px;'>

                                                <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('totalnf') ? ' is-invalid' : '' }}"
                                                        name="totalnf" id="input-totalnf" type="number" step="0.01"
                                                        value="{{ isset($pedido) ? $pedido->totalnf : old('totalnf') }}" placeholder="{{ __('Valor Total da NF') }}" readonly/>
                                                        @if ($errors->has('totalnf'))
                                                            <span id="totalnf-error" class="error text-danger"
                                                                for="input-totalnf">{{ $errors->first('totalnf') }}</span>
                                                        @endif

                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $evento ?? null])
    </div>
    @if(isset($evento))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $evento])
    </div>
    @endif
</div>


<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($evento) ? 'Atualizar' : 'Adicionar').' Evento') }}</button>
        <a href="{{ route('admin.eventos.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
        @if(isset($evento))
        <a class="btn bg-gradient-dark" href="{{route('admin.eventos.create')}}"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Novo Evento</a>
        @endif
    </div>
</div>

@push('js')
    @include('partials.upload-js')
    <script>
        $(document).ready(function() {
            // Quando o valor de input-data mudar
            $('#input-data').change(function() {
                // Obtenha a data do input-data
                var dataInicio = $(this).val();

                // Converta para um objeto Date
                var dataInicioObj = new Date(dataInicio);

                // Obtenha o valor de data-datapadrao do option selecionado em select-ideventotipo
                var diasParaAdicionar = parseInt($('#select-ideventotipo option:selected').data('datapadrao'), 10);

                // Verifique se diasParaAdicionar é um número. Se não for, defina como 0 ou qualquer valor padrão desejado
                if (isNaN(diasParaAdicionar)) {
                    diasParaAdicionar = 0; // ou valor padrão
                }

                // Adicione os dias
                dataInicioObj.setDate(dataInicioObj.getDate() + diasParaAdicionar);

                // Formate a data de volta para uma string no formato apropriado (assumindo yyyy-mm-dd)
                var dataFinal = dataInicioObj.toISOString().split('T')[0];

                // Defina o valor de input-datafim
                $('#input-datafim').val(dataFinal);
            });

            // Quando o valor de horaInicio mudar
            $('#input-hora').change(function() {
                var horaInicioStr = $(this).val();
                var horaPadraoStr = $('#select-ideventotipo option:selected').data('horapadrao');
                console.log('aaa');
                // Verifica se a hora de início e a hora padrão são válidas
                if (horaInicioStr && horaPadraoStr) {
                    // Converte a hora de início em um objeto Date
                    var horaInicio = new Date();
                    var partesHoraInicio = horaInicioStr.split(':');
                    horaInicio.setHours(partesHoraInicio[0], partesHoraInicio[1], 0);

                    // Separa as horas e os minutos de horaPadrao
                    var partesHoraPadrao = horaPadraoStr.split(':');
                    var horasParaAdicionar = parseInt(partesHoraPadrao[0], 10);
                    var minutosParaAdicionar = parseInt(partesHoraPadrao[1], 10);

                    // Adiciona as horas e minutos de horaPadrao
                    horaInicio.setHours(horaInicio.getHours() + horasParaAdicionar);
                    horaInicio.setMinutes(horaInicio.getMinutes() + minutosParaAdicionar);

                    // Formata a nova hora para atualizar horaFim
                    var horaFimStr = horaInicio.getHours().toString().padStart(2, '0') + ':' + horaInicio.getMinutes().toString().padStart(2, '0');

                    // Tenta selecionar o valor correspondente em #input-horafim
                    var horafimVal = horaFimStr;
                    // var corresponde = $('#input-horafim option[value="' + horafimVal + '"]').length > 0;
                    // if (corresponde) {
                    $('#input-horafim').val(horafimVal);
                    // } else {
                        // Se não houver correspondência, você pode escolher como lidar com isso
                        // Por exemplo, definir para o valor padrão ou deixar o campo em branco
                    //     $('#input-horafim').val(''); // ou qualquer outra lógica que você deseja implementar
                    // }
                }
            });

            // Quando o valor de select-ideventotipo mudar, atualize o input-datafim e input-horaFim também
                $('#select-ideventotipo').change(function() {
                    var dataInicio = $('#input-data').val();
                    var dataFim = $('#input-datafim').val();
                    var horaInicio = $('#horaInicio').val();
                    var horaPadrao = $('#select-ideventotipo option:selected').data('horapadrao');

                    // Verifica se a data de início e data de fim estão presentes
                    if (dataInicio && dataFim) {
                        // Aciona o evento change de input-data para recalcular a data de fim
                        $('#input-data').change();
                    }

                    // Verifica se a hora padrão foi fornecida e define a hora de início e hora de fim
                    if (horaPadrao) {
                        $('#horaInicio').val(horaPadrao);  // Configura a hora de início
                        $('#horaFim').val(horaPadrao);    // Configura a hora de fim
                    }
                });
        });


    </script>

<script>
    function ApresentaDados(select) {
        // Se nenhum select for passado, use o select com id 'select-ideventotipo'
        if (!select) {
            select = document.getElementById('select-ideventotipo');
        }

        // Continue com o restante do código
        var veiculo = select.options[select.selectedIndex].getAttribute('data-veiculo');
        var pessoa = select.options[select.selectedIndex].getAttribute('data-pessoa');
        var qtd = select.options[select.selectedIndex].getAttribute('data-qtd');
        var hora = select.options[select.selectedIndex].getAttribute('data-hora');
        var venda = select.options[select.selectedIndex].getAttribute('data-venda');
        var datapadrao = select.options[select.selectedIndex].getAttribute('data-datapadrao');
        var horapadrao = select.options[select.selectedIndex].getAttribute('data-horapadrao');
        var valorvenda = select.options[select.selectedIndex].getAttribute('data-valorvenda');
        var prodserv = select.options[select.selectedIndex].getAttribute('data-prodserv');
        var idprodserv = select.options[select.selectedIndex].getAttribute('data-idprodserv');

        var divVeiculo = document.getElementById('div-idveiculo');
        var divPessoa = document.getElementById('div-idpessoa');
        var divQtd = document.getElementById('div-qtd');
        var divHora = document.getElementById('div-hora');
        var divHoraFim = document.getElementById('div-horafim');
        var divVenda = document.getElementById('div-venda');

        if (veiculo === 'SIM') {
            divVeiculo.classList.remove('d-none');
        } else {
            divVeiculo.classList.add('d-none');
        }

        if (pessoa === 'SIM') {
            divPessoa.classList.remove('d-none');
        } else {
            divPessoa.classList.add('d-none');
        }
        if (qtd === 'SIM') {
            divQtd.classList.remove('d-none');
        } else {
            divQtd.classList.add('d-none');
        }
        if (hora === 'SIM') {
            divHora.classList.remove('d-none');
            divHoraFim.classList.remove('d-none');
        } else {
            divHora.classList.add('d-none');
            divHoraFim.classList.add('d-none');
        }
        if (venda === 'SIM') {
            divVenda.classList.remove('d-none');

            // Definindo os valores dos inputs
           // alert(document.getElementById('input-valorun').value);
            var inputValorUn = document.getElementById('input-valorun');
            var valorAtual = inputValorUn.value;

            // Verificando se o valor é vazio ou indefinido
            if (valorAtual === '' || valorAtual === undefined || valorAtual === undefined) {
                // Definindo o novo valor usando a função converterParaNumero
                inputValorUn.value = converterParaNumero(valorvenda);
            }else{
                document.getElementById('input-valorun').value = converterParaNumero(valorun);
            }
            document.getElementById('input-item').value = prodserv;
            document.getElementById('input-idprodserv').value = idprodserv;
            updateValorItem();

        } else {
            divVenda.classList.add('d-none');
        }
    }



    function updateValorItem() {
       // debugger;

        var qtd = converterParaNumero(document.getElementById('input-qtd').value) || 0;
        var valorUn = converterParaNumero(document.getElementById('input-valorun').value) || 0;

        if (!isNaN(parseFloat(valorUn)) && valorUn !== "" && valorUn !== undefined) {
        // O valor é válido e não é NaN
            valorUn = (valorUn);
            //alert(0);
        } else {
        // O valor é inválido ou NaN
            valorUn.value = 0;
           // alert(1);
        }

        if (!isNaN(parseFloat(qtd)) && qtd.value !== "" && qtd !== undefined) {
        // O valor é válido e não é NaN
            qtd = (qtd);
        } else {
        // O valor é inválido ou NaN
            qtd = 1;
        }
        var valorItem = qtd * valorUn;
        var valorItemInput = document.getElementById('input-valoritem');
        valorItemInput.value = valorItem.toFixed(2);

    }

    // Chama a função ApresentaDados quando a página é carregada
    document.addEventListener('DOMContentLoaded', function() {
        ApresentaDados();

        // Adicionar event listener para quando o valorun mudar
        document.getElementById('input-valorun').addEventListener('input', updateValorItem);

        // Adicionar event listener para quando a qtd mudar
        document.getElementById('input-qtd').addEventListener('input', updateValorItem);
    });


    function formatarEntradaNumerica(el) {
        // Primeiro, substitui todos os pontos por vírgulas
        let valor = el.value.replace(/\./g, ',');

        // Remove caracteres que não são dígitos ou vírgula
        valor = valor.replace(/[^0-9,]/g, '');

        // Permite apenas uma vírgula
        let partes = valor.split(',');
        if (partes.length > 2) {
            valor = partes[0] + ',' + partes.slice(1).join('');
        }

        el.value = valor;
    }

    function converterParaNumero(valor) {
        // Verifica se o valor é não nulo e não vazio
        if (valor) {
            // Converte vírgulas em pontos
            console.log(valor);
            var valorConvertido = valor.replace(',', '.');
            console.log(valorConvertido);
            // Converte para float e verifica se é NaN. Se for NaN, retorna 0
            var numero = parseFloat(valorConvertido);
            console.log(numero);
            return isNaN(numero) ? 0 : numero;
        }
        return 0;
    }

</script>
@endpush
